/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.math;

import com.morphismmc.morphismlib.math.MathUtil;

public final class BoundLong {
    private final long min;
    private final long max;
    public static final BoundLong MAX_BOUND = new BoundLong(Long.MIN_VALUE, Long.MAX_VALUE);

    public BoundLong(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public static BoundLong of(long min, long max) {
        return new BoundLong(min, max);
    }

    public long clamp(long num) {
        return MathUtil.clamp(num, this.min, this.max);
    }

    public BoundLong withMin(long newMin) {
        return this.min == newMin ? this : new BoundLong(newMin, this.max);
    }

    public BoundLong withMax(long newMax) {
        return this.max == newMax ? this : new BoundLong(this.min, newMax);
    }

    public String toString() {
        return "BoundLong[" + "min=" + this.min + "," + "max=" + this.max + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((BoundLong)arg0).min != this.min) {
            return false;
        }
        return ((BoundLong)arg0).max == this.max;
        {
        }
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }
}

