/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.math;

import net.minecraft.util.math.MathHelper;

public final class BoundInt {
    private final int min;
    private final int max;
    public static final BoundInt MAX_BOUND = new BoundInt(Integer.MIN_VALUE, Integer.MAX_VALUE);

    public BoundInt(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static BoundInt of(int min, int max) {
        return new BoundInt(min, max);
    }

    public int clamp(int num) {
        return MathHelper.func_76125_a((int)num, (int)this.min, (int)this.max);
    }

    public BoundInt withMin(int newMin) {
        return this.min == newMin ? this : new BoundInt(newMin, this.max);
    }

    public BoundInt withMax(int newMax) {
        return this.max == newMax ? this : new BoundInt(this.min, newMax);
    }

    public String toString() {
        return "BoundInt[" + "min=" + this.min + "," + "max=" + this.max + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((BoundInt)arg0).min != this.min) {
            return false;
        }
        return ((BoundInt)arg0).max == this.max;
        {
        }
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }
}

