/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.math;

import net.minecraft.util.math.MathHelper;

public final class BoundDouble {
    private final double min;
    private final double max;
    public static final BoundDouble MAX_BOUND = new BoundDouble(Double.MIN_VALUE, Double.MAX_VALUE);

    public BoundDouble(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public static BoundDouble of(double min, double max) {
        return new BoundDouble(min, max);
    }

    public double clamp(double val) {
        return MathHelper.func_151237_a((double)val, (double)this.min, (double)this.max);
    }

    public BoundDouble withMin(double newMin) {
        return this.min == newMin ? this : new BoundDouble(newMin, this.max);
    }

    public BoundDouble withMax(double newMax) {
        return this.max == newMax ? this : new BoundDouble(this.min, newMax);
    }

    public String toString() {
        return "BoundDouble[" + "min=" + this.min + "," + "max=" + this.max + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (int)(Double.doubleToLongBits(this.min) ^ Double.doubleToLongBits(this.min) >>> 32);
        result = 31 * result + (int)(Double.doubleToLongBits(this.max) ^ Double.doubleToLongBits(this.max) >>> 32);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (((BoundDouble)arg0).min != this.min) {
            return false;
        }
        return ((BoundDouble)arg0).max == this.max;
        {
        }
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }
}

