/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.integration;

import com.morphismmc.morphismlib.util.Envs;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.Nullable;

public enum Mods {
    AdvancedRocketry("advancedrocketry"),
    AppliedEnergistics2("appliedenergistics2"),
    Baubles("baubles"),
    BetterQuestingUnofficial("betterquesting"){

        @Override
        protected boolean extraCheck(ModContainer container) {
            String[] versions = container.getVersion().split("\\.");
            if (versions.length == 0) {
                return false;
            }
            try {
                return Integer.parseInt(versions[0]) >= 4;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
    ,
    BinnieCore("binniecore"),
    BiomesOPlenty("biomesoplenty"),
    BuildCraftCore("buildcraftcore"),
    Chisel("chisel"),
    CoFHCore("cofhcore"),
    CTM("ctm"),
    CubicChunks("cubicchunks"),
    CraftTweaker("crafttweaker"),
    EnderCore("endercore"),
    EnderIO("enderio"),
    ExtraBees("extrabees"),
    ExtraTrees("extratrees"),
    ExtraUtilities2("extrautils2"),
    Forestry("forestry"),
    GalacticraftCore("galacticraftcore"),
    Genetics("genetics"),
    GregTech("gregtech"),
    GregTechFoodOption("gregtechfoodoption"),
    GroovyScript("groovyscript"),
    GTCE2OC("gtce2oc"),
    HWYLA("hwyla"),
    ImmersiveEngineering("immersiveengineering"),
    IndustrialCraft2("ic2"),
    InventoryBogoSorter("bogosorter"),
    InventoryTweaks("inventorytweaks"),
    JourneyMap("journeymap"),
    JustEnoughItems("jei"),
    LittleTiles("littletiles"),
    MagicBees("magicbees"),
    Nothirium("nothirium"),
    NuclearCraft("nuclearcraft"){

        @Override
        protected boolean extraCheck(ModContainer container) {
            return !container.getVersion().contains("2o");
        }
    }
    ,
    NuclearCraftOverhauled("nuclearcraft"){

        @Override
        protected boolean extraCheck(ModContainer container) {
            return container.getVersion().contains("2o");
        }
    }
    ,
    OpenComputers("opencomputers"),
    ProjectRedCore("projred-core"),
    Railcraft("railcraft"),
    RefinedStorage("refinedstorage"),
    TechReborn("techreborn"),
    TheOneProbe("theoneprobe"),
    TinkersConstruct("tconstruct"),
    TOPAddons("topaddons"),
    VoxelMap("voxelmap"),
    XaerosMinimap("xaerominimap"),
    Vintagium("vintagium"),
    Alfheim("alfheim");

    private final String id;
    private final ModContainer container;
    private final boolean isLoaded;
    private boolean isActive;
    private boolean canDisableRuntime;

    private Mods(String modId) {
        this.id = modId;
        Map modList = Loader.instance().getIndexedModList();
        if (modList.isEmpty()) {
            throw new IllegalStateException("Mods was initialized too early!");
        }
        this.container = (ModContainer)modList.get(modId);
        boolean bl = this.isLoaded = this.container != null && this.extraCheck(this.container);
        if (this.isLoaded) {
            this.canDisableRuntime = Envs.isClient() && this.container.canBeDisabled() == ModContainer.Disableable.YES;
            this.isActive = Loader.isModLoaded((String)this.id);
        }
    }

    public boolean isActive() {
        return this.canDisableRuntime ? Loader.isModLoaded((String)this.id) : this.isActive;
    }

    protected boolean extraCheck(ModContainer container) {
        return true;
    }

    public ResourceLocation id(String path) {
        return new ResourceLocation(this.id, path);
    }

    public ItemStack getItem(String name) {
        return this.getItem(name, 0, 1, null);
    }

    public ItemStack getItem(String name, int meta) {
        return this.getItem(name, meta, 1, null);
    }

    public ItemStack getItem(String name, int meta, int amount) {
        return this.getItem(name, meta, amount, null);
    }

    public ItemStack getItem(String name, int meta, int amount, @Nullable String nbt) {
        if (!this.isActive()) {
            return ItemStack.field_190927_a;
        }
        return GameRegistry.makeItemStack((String)(this.id + ":" + name), (int)meta, (int)amount, (String)nbt);
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public ModContainer container() {
        return this.container;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }
}

