/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.ARGB;
import net.minecraft.util.math.MathHelper;

public final class RGBA {
    public static int color(float red, float green, float blue) {
        return RGBA.color(red, green, blue, 1.0f);
    }

    public static int color(float red, float green, float blue, float alpha) {
        return RGBA.color(MathHelper.func_76141_d((float)(red * 255.0f)), MathHelper.func_76141_d((float)(green * 255.0f)), MathHelper.func_76141_d((float)(blue * 255.0f)), MathHelper.func_76141_d((float)(alpha * 255.0f)));
    }

    public static int color(int red, int green, int blue) {
        return RGBA.color(red, green, blue, 255);
    }

    public static int color(int red, int green, int blue, int alpha) {
        return red << 24 | green << 16 | blue << 8 | alpha;
    }

    public static int fromArgb(int argb) {
        return RGBA.color(ARGB.red(argb), ARGB.green(argb), ARGB.blue(argb), ARGB.alpha(argb));
    }

    public static int withRed(int rgba, int red) {
        return (rgba &= 0xFFFFFF) | red << 24;
    }

    public static int withGreen(int rgba, int green) {
        return (rgba &= 0xFF00FFFF) | green << 16;
    }

    public static int withBlue(int rgba, int blue) {
        return (rgba &= 0xFFFF00FF) | blue << 8;
    }

    public static int withAlpha(int rgba, int alpha) {
        return (rgba &= 0xFFFFFF00) | alpha;
    }

    public static int withRed(int rgba, float red) {
        return RGBA.withRed(rgba, (int)(red * 255.0f));
    }

    public static int withGreen(int rgba, float green) {
        return RGBA.withGreen(rgba, (int)(green * 255.0f));
    }

    public static int withBlue(int rgba, float blue) {
        return RGBA.withBlue(rgba, (int)(blue * 255.0f));
    }

    public static int withAlpha(int rgba, float alpha) {
        return RGBA.withAlpha(rgba, (int)(alpha * 255.0f));
    }

    public static float red(int rgba) {
        return (float)RGBA.redI(rgba) / 255.0f;
    }

    public static int redI(int rgba) {
        return rgba >> 24 & 0xFF;
    }

    public static float green(int rgba) {
        return (float)RGBA.greenI(rgba) / 255.0f;
    }

    public static int greenI(int rgba) {
        return rgba >> 16 & 0xFF;
    }

    public static float blue(int rgba) {
        return (float)RGBA.blueI(rgba) / 255.0f;
    }

    public static int blueI(int rgba) {
        return rgba >> 8 & 0xFF;
    }

    public static float alpha(int rgba) {
        return (float)RGBA.alphaI(rgba) / 255.0f;
    }

    public static int alphaI(int rgba) {
        return rgba & 0xFF;
    }

    private RGBA() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

