/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.ARGB;
import net.minecraft.util.math.MathHelper;

public final class HSV {
    public static int color(float hue, float saturation, float value) {
        return HSV.color(hue, saturation, value, 1.0f);
    }

    public static int color(float hue, float saturation, float value, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)1.0f);
        value = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        float c = value * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = value - c;
        return HSV.ofHxcm(hue, c, x, m, alpha);
    }

    public static int withHue(int argb, float hue) {
        return HSV.color(hue, HSV.saturation(argb), HSV.value(argb), ARGB.alpha(argb));
    }

    public static int withSaturation(int argb, float saturation) {
        return HSV.color(HSV.hue(argb), saturation, HSV.value(argb), ARGB.alpha(argb));
    }

    public static int withValue(int argb, float value) {
        return HSV.color(HSV.hue(argb), HSV.saturation(argb), value, ARGB.alpha(argb));
    }

    public static float hue(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        if (r == g && r == b) {
            return 0.0f;
        }
        float min = Math.min(r, Math.min(g, b));
        float hue = 0.0f;
        if (r >= g && r >= b) {
            hue = (g - b) / (r - min) % 6.0f;
        } else if (g >= r && g >= b) {
            hue = (b - r) / (g - min) + 2.0f;
        } else if (b >= r && b >= g) {
            hue = (r - g) / (b - min) + 4.0f;
        }
        hue *= 60.0f;
        if (hue < 0.0f) {
            hue += 360.0f;
        }
        return hue;
    }

    public static float saturation(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return max == 0.0f ? 0.0f : (max - min) / max;
    }

    public static float value(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        return Math.max(r, Math.max(g, b));
    }

    static int ofHxcm(float hue, float c, float x, float m, float alpha) {
        if (hue < 60.0f) {
            return ARGB.color(c + m, x + m, m, alpha);
        }
        if (hue < 120.0f) {
            return ARGB.color(x + m, c + m, m, alpha);
        }
        if (hue < 180.0f) {
            return ARGB.color(m, c + m, x + m, alpha);
        }
        if (hue < 240.0f) {
            return ARGB.color(m, x + m, c + m, alpha);
        }
        if (hue < 300.0f) {
            return ARGB.color(x + m, m, c + m, alpha);
        }
        return ARGB.color(c + m, m, x + m, alpha);
    }

    private HSV() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

