/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.ARGB;
import com.morphismmc.morphismlib.color.HSV;
import net.minecraft.util.math.MathHelper;

public final class HSL {
    public static int color(float hue, float saturation, float lightness) {
        return HSL.color(hue, saturation, lightness, 1.0f);
    }

    public static int color(float hue, float saturation, float lightness, float alpha) {
        if ((hue %= 360.0f) < 0.0f) {
            hue += 360.0f;
        }
        saturation = MathHelper.func_76131_a((float)saturation, (float)0.0f, (float)1.0f);
        lightness = MathHelper.func_76131_a((float)lightness, (float)0.0f, (float)1.0f);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        float c = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
        float x = c * (1.0f - Math.abs(hue / 60.0f % 2.0f - 1.0f));
        float m = lightness - c / 2.0f;
        return HSV.ofHxcm(hue, c, x, m, alpha);
    }

    public static int withHue(int argb, float hue) {
        return HSL.color(hue, HSL.saturation(argb), HSL.lightness(argb), ARGB.alpha(argb));
    }

    public static int withSaturation(int argb, float saturation) {
        return HSL.color(HSL.hue(argb), saturation, HSL.lightness(argb), ARGB.alpha(argb));
    }

    public static int withLightness(int argb, float lightness) {
        return HSL.color(HSL.hue(argb), HSL.saturation(argb), lightness, ARGB.alpha(argb));
    }

    public static float hue(int argb) {
        return HSV.hue(argb);
    }

    public static float saturation(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max - min) / (1.0f - Math.abs(max + min - 1.0f));
    }

    public static float lightness(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        return (max + min) / 2.0f;
    }

    private HSL() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

