/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.ARGB;
import com.morphismmc.morphismlib.color.HSV;

public final class ColorUtil {
    public static int invert(int argb) {
        return ARGB.color(255.0f - ARGB.red(argb), 255.0f - ARGB.green(argb), 255.0f - ARGB.blue(argb), ARGB.alpha(argb));
    }

    public static int multiply(int argb, float factor, boolean multiplyAlpha) {
        return ARGB.color(ARGB.red(argb) * factor, ARGB.green(argb) * factor, ARGB.blue(argb) * factor, multiplyAlpha ? ARGB.alpha(argb) * factor : ARGB.alpha(argb));
    }

    public static int average(int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        for (int color : colors) {
            r += ARGB.redI(color);
            g += ARGB.greenI(color);
            b += ARGB.blueI(color);
            a += ARGB.alphaI(color);
        }
        return ARGB.color(r / colors.length, g / colors.length, b / colors.length, a / colors.length);
    }

    public static int rainbowColor(long tick) {
        float hue = (float)(tick % 70L) / 70.0f;
        int rgb = HSV.color(hue, 1.0f, 1.0f);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static int rainbowColor() {
        float hue = (float)(System.currentTimeMillis() % 3600L) / 3600.0f;
        int rgb = HSV.color(hue, 1.0f, 1.0f);
        return 0xFF000000 | rgb & 0xFFFFFF;
    }

    public static int rainbowColor(int timeStep) {
        int localTimeStep = Math.abs(timeStep) % 1536;
        int timeStepInPhase = localTimeStep % 256;
        int phaseBlue = localTimeStep / 256;
        int red = ColorUtil.colorInPhase(phaseBlue + 4, timeStepInPhase);
        int green = ColorUtil.colorInPhase(phaseBlue + 2, timeStepInPhase);
        int blue = ColorUtil.colorInPhase(phaseBlue, timeStepInPhase);
        return ARGB.color(1, red, green, blue);
    }

    private static int colorInPhase(int phase, int progress) {
        if ((phase %= 6) <= 1) {
            return 0;
        }
        if (phase == 2) {
            return progress;
        }
        if (phase <= 4) {
            return 255;
        }
        return 255 - progress;
    }

    public static String toHex(int argb) {
        return ColorUtil.toHex(argb, true);
    }

    public static String toHex(int argb, boolean includeAlpha) {
        return includeAlpha ? String.format("#%08X", argb) : String.format("#%06X", ARGB.withAlpha(argb, 1.0f));
    }

    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

