/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.ARGB;

public final class CMYK {
    public static int color(float cyan, float magenta, float yellow, float black) {
        return CMYK.color(cyan, magenta, yellow, black, 1.0f);
    }

    public static int color(float cyan, float magenta, float yellow, float black, float alpha) {
        float oneMinusBlack = 1.0f - black;
        return ARGB.color((1.0f - cyan) * oneMinusBlack, (1.0f - magenta) * oneMinusBlack, (1.0f - yellow) * oneMinusBlack, alpha);
    }

    public static int withCyan(int argb, float cyan) {
        return CMYK.color(cyan, CMYK.magenta(argb), CMYK.yellow(argb), CMYK.black(argb), ARGB.alpha(argb));
    }

    public static int withMagenta(int argb, float magenta) {
        return CMYK.color(CMYK.cyan(argb), magenta, CMYK.yellow(argb), CMYK.black(argb), ARGB.alpha(argb));
    }

    public static int withYellow(int argb, float yellow) {
        return CMYK.color(CMYK.cyan(argb), CMYK.magenta(argb), yellow, CMYK.black(argb), ARGB.alpha(argb));
    }

    public static int withBlack(int argb, float black) {
        return CMYK.color(CMYK.cyan(argb), CMYK.magenta(argb), CMYK.yellow(argb), black, ARGB.alpha(argb));
    }

    public static float cyan(int argb) {
        float b;
        float g;
        float r = ARGB.red(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = ARGB.green(argb), b = ARGB.blue(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - r / oneMinusBlack;
    }

    public static float magenta(int argb) {
        float b;
        float g;
        float r = ARGB.red(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = ARGB.green(argb), b = ARGB.blue(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - g / oneMinusBlack;
    }

    public static float yellow(int argb) {
        float b;
        float g;
        float r = ARGB.red(argb);
        float oneMinusBlack = Math.max(r, Math.max(g = ARGB.green(argb), b = ARGB.blue(argb)));
        return oneMinusBlack == 0.0f ? 0.0f : 1.0f - b / oneMinusBlack;
    }

    public static float black(int argb) {
        float r = ARGB.red(argb);
        float g = ARGB.green(argb);
        float b = ARGB.blue(argb);
        return 1.0f - Math.max(r, Math.max(g, b));
    }

    private CMYK() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

