/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.color;

import com.morphismmc.morphismlib.color.RGBA;
import net.minecraft.util.math.MathHelper;

public final class ARGB {
    public static int color(float red, float green, float blue) {
        return ARGB.color(1.0f, red, green, blue);
    }

    public static int color(float alpha, float red, float green, float blue) {
        return ARGB.color(MathHelper.func_76141_d((float)(alpha * 255.0f)), MathHelper.func_76141_d((float)(red * 255.0f)), MathHelper.func_76141_d((float)(green * 255.0f)), MathHelper.func_76141_d((float)(blue * 255.0f)));
    }

    public static int color(int red, int green, int blue) {
        return ARGB.color(255, red, green, blue);
    }

    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int fromRgba(int rgba) {
        return ARGB.color(RGBA.alpha(rgba), RGBA.red(rgba), RGBA.green(rgba), RGBA.blue(rgba));
    }

    public static int withAlpha(int argb, int alpha) {
        return (argb &= 0xFFFFFF) | alpha << 24;
    }

    public static int withRed(int argb, int red) {
        return (argb &= 0xFF00FFFF) | red << 16;
    }

    public static int withGreen(int argb, int green) {
        return (argb &= 0xFFFF00FF) | green << 8;
    }

    public static int withBlue(int argb, int blue) {
        return (argb &= 0xFFFFFF00) | blue;
    }

    public static int withAlpha(int argb, float alpha) {
        return ARGB.withAlpha(argb, (int)(alpha * 255.0f));
    }

    public static int withRed(int argb, float red) {
        return ARGB.withRed(argb, (int)(red * 255.0f));
    }

    public static int withGreen(int argb, float green) {
        return ARGB.withGreen(argb, (int)(green * 255.0f));
    }

    public static int withBlue(int argb, float blue) {
        return ARGB.withBlue(argb, (int)(blue * 255.0f));
    }

    public static float alpha(int argb) {
        return (float)ARGB.alphaI(argb) / 255.0f;
    }

    public static int alphaI(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static float red(int argb) {
        return (float)ARGB.redI(argb) / 255.0f;
    }

    public static int redI(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static float green(int argb) {
        return (float)ARGB.greenI(argb) / 255.0f;
    }

    public static int greenI(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static float blue(int argb) {
        return (float)ARGB.blueI(argb) / 255.0f;
    }

    public static int blueI(int argb) {
        return argb & 0xFF;
    }

    private ARGB() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

