/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.collection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Unmodifiable;

public final class ListOps {
    public static <E> @Unmodifiable List<E> of() {
        return Collections.emptyList();
    }

    @SafeVarargs
    public static <E> @Unmodifiable List<E> of(E ... elements) {
        return ImmutableList.copyOf((Object[])elements);
    }

    @SafeVarargs
    public static <E> List<E> ofMutable(E ... elements) {
        return Lists.newArrayList((Object[])elements);
    }

    public static <E> @Unmodifiable List<E> copyOf(Collection<? extends E> collection) {
        return ImmutableList.copyOf(collection);
    }

    private ListOps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

