/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.collection;

import com.morphismmc.morphismlib.util.ItemUtil;
import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean item;
        private boolean count;
        private boolean damage;
        private boolean tag;
        private boolean meta;

        public Builder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public Builder compareCount(boolean choice) {
            this.count = choice;
            return this;
        }

        public Builder compareDamage(boolean choice) {
            this.damage = choice;
            return this;
        }

        public Builder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    return o == null || o.func_190926_b() ? 0 : Objects.hash(item ? o.func_77973_b() : null, count ? Integer.valueOf(o.func_190916_E()) : null, damage ? Integer.valueOf(ItemUtil.getItemDamage(o)) : null, tag ? o.func_77978_p() : null);
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.func_190926_b()) {
                        return b == null || b.func_190926_b();
                    }
                    if (b == null || b.func_190926_b()) {
                        return false;
                    }
                    return !(item && a.func_77973_b() != b.func_77973_b() || count && a.func_190916_E() != b.func_190916_E() || damage && ItemUtil.getItemDamage(a) != ItemUtil.getItemDamage(b) || tag && !Objects.equals(a.func_77978_p(), b.func_77978_p()));
                }
            };
        }
    }
}

