/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.collection;

import com.morphismmc.morphismlib.util.ItemHandlerUtil;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class GameIterators {
    public static Iterator<ItemStack> wrap(IItemHandler handler) {
        return new ItemHandlerIterator(handler);
    }

    private GameIterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class ItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler handler;
        private final int size;
        private int count = 0;

        public ItemHandlerIterator(IItemHandler handler) {
            this.handler = handler;
            this.size = handler.getSlots();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.size;
        }

        @Override
        public ItemStack next() {
            return this.handler.getStackInSlot(this.count++);
        }

        @Override
        public void remove() {
            ItemHandlerUtil.setStackInSlot(this.handler, this.count - 1, ItemStack.field_190927_a);
        }
    }
}

