/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.collection;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public interface FluidStackHashStrategy
extends Hash.Strategy<FluidStack> {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean fluid;
        private boolean amount;
        private boolean tag;

        public Builder compareFluid(boolean choice) {
            this.fluid = choice;
            return this;
        }

        public Builder compareAmount(boolean choice) {
            this.amount = choice;
            return this;
        }

        public Builder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public FluidStackHashStrategy build() {
            return new FluidStackHashStrategy(){

                public int hashCode(@Nullable FluidStack o) {
                    return o == null ? 0 : Objects.hash(fluid ? o.getFluid() : null, amount ? Integer.valueOf(o.amount) : null, tag ? o.tag : null);
                }

                public boolean equals(@Nullable FluidStack a, @Nullable FluidStack b) {
                    if (a == null) {
                        return b == null;
                    }
                    if (b == null) {
                        return false;
                    }
                    return !(fluid && a.getFluid() != b.getFluid() || amount && a.amount != b.amount || tag && !Objects.equals(a.tag, b.tag));
                }
            };
        }
    }
}

