/*
 * Decompiled with CFR 0.152.
 */
package com.morphismmc.morphismlib.client;

import com.morphismmc.morphismlib.client.Games;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="morphismlib", value={Side.CLIENT})
public final class TickCounter {
    private static long serverLevelTickCount = 0L;
    private static long clientTickCount = 0L;
    private static long clientLevelTickCount = 0L;

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            ++clientTickCount;
            if (Games.connection() != null && !Games.isPaused()) {
                ++clientLevelTickCount;
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T()) {
            ++serverLevelTickCount;
        }
    }

    public static void onIntegratedServerStarted() {
        serverLevelTickCount = 0L;
    }

    private TickCounter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static long serverLevelTickCount() {
        return serverLevelTickCount;
    }

    public static long clientTickCount() {
        return clientTickCount;
    }

    public static long clientLevelTickCount() {
        return clientLevelTickCount;
    }
}

