/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.impl;

import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockRubberLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public class WorldGenRubberTree
extends WorldGenAbstractTree {
    public static final WorldGenRubberTree INSTANCE = new WorldGenRubberTree(false);
    public static final WorldGenRubberTree INSTANCE_NOTIFY = new WorldGenRubberTree(true);

    protected WorldGenRubberTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(@NotNull World world, @NotNull Random rand, @NotNull BlockPos pos) {
        int y;
        int trunkHeight = rand.nextInt(3) + 5;
        int maxWorldHeight = world.func_72800_K();
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (posY <= 1) {
            return false;
        }
        int topLeafHeight = trunkHeight + 3;
        int ySpaceRequired = posY + topLeafHeight + 1;
        int leafStartY = ySpaceRequired - 2;
        if (ySpaceRequired >= maxWorldHeight) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y2 = posY; y2 < ySpaceRequired; ++y2) {
            int radius = y2 == posY ? 0 : (y2 < leafStartY ? 1 : 2);
            int xLimit = posX + radius;
            int zLimit = posZ + radius;
            for (int x = posX - radius; x <= xLimit; ++x) {
                for (int z = posZ - radius; z < zLimit; ++z) {
                    mutable.func_181079_c(x, y2, z);
                    if (this.isReplaceable(world, (BlockPos)mutable)) continue;
                    return false;
                }
            }
        }
        mutable.func_181079_c(posX, posY - 1, posZ);
        IBlockState soilState = world.func_180495_p((BlockPos)mutable);
        Block soilBlock = soilState.func_177230_c();
        if (!soilBlock.canSustainPlant(soilState, (IBlockAccess)world, (BlockPos)mutable, EnumFacing.UP, (IPlantable)MetaBlocks.RUBBER_SAPLING)) {
            return false;
        }
        soilBlock.onPlantGrow(soilState, world, (BlockPos)mutable, pos);
        int leavesOnTrunk = 4;
        int slimmingPoint = trunkHeight - 2;
        int leafRadius = 2;
        for (int yOffset = trunkHeight - 4; yOffset < topLeafHeight; ++yOffset) {
            if (yOffset == slimmingPoint) {
                leafRadius = 1;
            } else if (yOffset == trunkHeight) {
                leafRadius = 0;
            }
            y = posY + yOffset;
            for (int xOffset = -leafRadius; xOffset <= leafRadius; ++xOffset) {
                int x = posX + xOffset;
                for (int zOffset = -leafRadius; zOffset <= leafRadius; ++zOffset) {
                    int z = posZ + zOffset;
                    if (y <= trunkHeight && xOffset == 0 && zOffset == 0 || leafRadius != 0 && Math.abs(xOffset) >= leafRadius && Math.abs(zOffset) >= leafRadius && (yOffset > slimmingPoint || !rand.nextBoolean())) continue;
                    mutable.func_181079_c(x, y, z);
                    IBlockState existing = world.func_180495_p((BlockPos)mutable);
                    if (!existing.func_177230_c().isAir(existing, (IBlockAccess)world, (BlockPos)mutable)) continue;
                    this.func_175903_a(world, (BlockPos)mutable, MetaBlocks.RUBBER_LEAVES.func_176223_P());
                }
            }
        }
        IBlockState logState = MetaBlocks.RUBBER_LOG.func_176223_P().func_177226_a((IProperty)BlockRubberLog.NATURAL, (Comparable)Boolean.valueOf(true));
        mutable.func_181079_c(posX, posY, posZ);
        for (y = 0; y < trunkHeight; ++y) {
            mutable.func_185336_p(posY + y);
            IBlockState existing = world.func_180495_p((BlockPos)mutable);
            if (!existing.func_177230_c().isAir(existing, (IBlockAccess)world, (BlockPos)mutable) && !existing.func_177230_c().isLeaves(existing, (IBlockAccess)world, (BlockPos)mutable)) continue;
            this.func_175903_a(world, (BlockPos)mutable, logState);
        }
        return true;
    }
}

