/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregtech.api.modules.GregTechModule;
import gregtech.common.ConfigHolder;
import gregtech.modules.BaseGregTechModule;
import gregtech.worldgen.impl.WorldGenRubberTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@GregTechModule(moduleID="worldgen", containerID="gregtech", name="GregTech Worldgen", description="GregTech Worldgen Module.")
public class WorldgenModule
extends BaseGregTechModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"GregTech Worldgen");
    private static final Set<OreGenEvent.GenerateMinable.EventType> VANILLA_ORE_GEN_EVENT_TYPES = EnumSet.of(OreGenEvent.GenerateMinable.EventType.COAL, new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.QUARTZ, OreGenEvent.GenerateMinable.EventType.EMERALD});

    @Override
    @NotNull
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    @NotNull
    public List<Class<?>> getTerrainGenBusSubscribers() {
        return Collections.singletonList(WorldgenModule.class);
    }

    @Override
    @NotNull
    public List<Class<?>> getOreGenBusSubscribers() {
        return Collections.singletonList(WorldgenModule.class);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onGenerateMineable(@NotNull OreGenEvent.GenerateMinable event) {
        if (ConfigHolder.worldgen.disableVanillaOres && VANILLA_ORE_GEN_EVENT_TYPES.contains(event.getType())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onBiomeDecorate(@NotNull DecorateBiomeEvent.Decorate event) {
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.TREE) {
            if (ConfigHolder.worldgen.disableRubberTreeGeneration) {
                return;
            }
            if (WorldgenModule.generateRubberTrees(event.getWorld(), event.getChunkPos(), event.getRand())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static boolean generateRubberTrees(@NotNull World world, @NotNull ChunkPos chunkPos, @NotNull Random random) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int chunkX = chunkPos.field_77276_a * 16;
        int chunkZ = chunkPos.field_77275_b * 16;
        pos.func_181079_c(chunkX + 16, 0, chunkZ + 16);
        Biome biome = world.func_180494_b((BlockPos)pos);
        int amount = 0;
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            amount += random.nextInt(10) + 5;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            amount += random.nextInt(5) + 1;
        }
        if ((amount = (int)((double)amount * ConfigHolder.worldgen.rubberTreeRateIncrease / 2.0)) > 0 && random.nextInt(100) < amount) {
            boolean generated = false;
            for (int i = 0; i < amount; ++i) {
                int x = chunkX + random.nextInt(16) + 8;
                int z = chunkZ + random.nextInt(16) + 8;
                int y = world.func_189649_b(x, z);
                pos.func_181079_c(x, y, z);
                WorldGenRubberTree.INSTANCE.func_175904_e();
                if (!WorldGenRubberTree.INSTANCE.func_180709_b(world, random, (BlockPos)pos)) continue;
                WorldGenRubberTree.INSTANCE.func_180711_a(world, random, (BlockPos)pos);
                generated = true;
            }
            return generated;
        }
        return false;
    }
}

