/*
 * Decompiled with CFR 0.152.
 */
package gregtech.modules;

import com.google.common.base.Preconditions;
import gregtech.api.modules.GregTechModule;
import gregtech.api.modules.IGregTechModule;
import gregtech.api.modules.IModuleContainer;
import gregtech.api.modules.IModuleManager;
import gregtech.api.modules.ModuleContainer;
import gregtech.api.modules.ModuleStage;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ModuleManager
implements IModuleManager {
    private static final ModuleManager INSTANCE = new ModuleManager();
    private static final String MODULE_CFG_FILE_NAME = "modules.cfg";
    private static final String MODULE_CFG_CATEGORY_NAME = "modules";
    private static File configFolder;
    private Map<String, IModuleContainer> containers = new Object2ReferenceLinkedOpenHashMap();
    private final Map<ResourceLocation, IGregTechModule> sortedModules = new Object2ReferenceLinkedOpenHashMap();
    private final Set<IGregTechModule> loadedModules = new ReferenceLinkedOpenHashSet();
    @Nullable
    private IModuleContainer currentContainer;
    private ModuleStage currentStage = ModuleStage.C_SETUP;
    private static final Logger logger;
    private Configuration config;

    private ModuleManager() {
    }

    public static ModuleManager getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isModuleEnabled(@NotNull ResourceLocation id) {
        return this.sortedModules.containsKey(id);
    }

    private boolean isModuleEnabled(@NotNull IGregTechModule module) {
        GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
        String comment = ModuleManager.getComment(module);
        Property prop = this.getConfiguration().get(MODULE_CFG_CATEGORY_NAME, annotation.containerID() + ":" + annotation.moduleID(), true, comment);
        return prop.getBoolean();
    }

    @Override
    @Nullable
    public IModuleContainer getLoadedContainer() {
        return this.currentContainer;
    }

    @Override
    @NotNull
    public ModuleStage getStage() {
        return this.currentStage;
    }

    @Override
    public boolean hasPassedStage(@NotNull ModuleStage stage) {
        return this.currentStage.ordinal() > stage.ordinal();
    }

    @Override
    public void registerContainer(@NotNull IModuleContainer container) {
        if (this.currentStage != ModuleStage.C_SETUP) {
            logger.error("Failed to register module container {}, as module loading has already begun", (Object)container);
            return;
        }
        Preconditions.checkNotNull((Object)container);
        this.containers.put(container.getID(), container);
    }

    public void setup(@NotNull ASMDataTable asmDataTable, @NotNull File configDirectory) {
        this.discoverContainers(asmDataTable);
        this.containers = (Map)this.containers.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, Object2ReferenceLinkedOpenHashMap::new));
        this.currentStage = ModuleStage.M_SETUP;
        configFolder = new File(configDirectory, "gregtech");
        Map<String, List<IGregTechModule>> modules = ModuleManager.getModules(asmDataTable);
        this.configureModules(modules);
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Registering event handlers");
            for (Class<?> clazz : module.getEventBusSubscribers()) {
                MinecraftForge.EVENT_BUS.register(clazz);
            }
            for (Class<?> clazz : module.getTerrainGenBusSubscribers()) {
                MinecraftForge.TERRAIN_GEN_BUS.register(clazz);
            }
            for (Class<?> clazz : module.getOreGenBusSubscribers()) {
                MinecraftForge.ORE_GEN_BUS.register(clazz);
            }
        }
        this.currentContainer = null;
    }

    public void onConstruction(@NotNull FMLConstructionEvent event) {
        this.currentStage = ModuleStage.CONSTRUCTION;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Construction start");
            module.construction(event);
            module.getLogger().debug("Construction complete");
        }
        this.currentContainer = null;
    }

    public void onPreInit(@NotNull FMLPreInitializationEvent event) {
        this.currentStage = ModuleStage.PRE_INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Registering packets");
            module.registerPackets();
        }
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Pre-init start");
            module.preInit(event);
            module.getLogger().debug("Pre-init complete");
        }
        this.currentContainer = null;
    }

    public void onInit(@NotNull FMLInitializationEvent event) {
        this.currentStage = ModuleStage.INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Init start");
            module.init(event);
            module.getLogger().debug("Init complete");
        }
        this.currentContainer = null;
    }

    public void onPostInit(@NotNull FMLPostInitializationEvent event) {
        this.currentStage = ModuleStage.POST_INIT;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Post-init start");
            module.postInit(event);
            module.getLogger().debug("Post-init complete");
        }
        this.currentContainer = null;
    }

    public void onLoadComplete(@NotNull FMLLoadCompleteEvent event) {
        this.currentStage = ModuleStage.FINISHED;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Load-complete start");
            module.loadComplete(event);
            module.getLogger().debug("Load-complete complete");
        }
        this.currentContainer = null;
    }

    public void onServerAboutToStart(@NotNull FMLServerAboutToStartEvent event) {
        this.currentStage = ModuleStage.SERVER_ABOUT_TO_START;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Server-about-to-start start");
            module.serverAboutToStart(event);
            module.getLogger().debug("Server-about-to-start complete");
        }
        this.currentContainer = null;
    }

    public void onServerStarting(@NotNull FMLServerStartingEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTING;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Server-starting start");
            module.serverStarting(event);
            module.getLogger().debug("Server-starting complete");
        }
        this.currentContainer = null;
    }

    public void onServerStarted(@NotNull FMLServerStartedEvent event) {
        this.currentStage = ModuleStage.SERVER_STARTED;
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.getLogger().debug("Server-started start");
            module.serverStarted(event);
            module.getLogger().debug("Server-started complete");
        }
        this.currentContainer = null;
    }

    public void onServerStopping(@NotNull FMLServerStoppingEvent event) {
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.serverStopping(event);
        }
        this.currentContainer = null;
    }

    public void onServerStopped(@NotNull FMLServerStoppedEvent event) {
        for (IGregTechModule module : this.loadedModules) {
            this.currentContainer = this.containers.get(ModuleManager.getContainerID(module));
            module.serverStopped(event);
        }
        this.currentContainer = null;
    }

    public void processIMC(@NotNull @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            for (IGregTechModule module : this.loadedModules) {
                if (module.processIMC(message)) break;
            }
        }
    }

    private void configureModules(@NotNull Map<String, List<IGregTechModule>> modules) {
        IGregTechModule module;
        Iterator iterator;
        boolean changed;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        ObjectLinkedOpenHashSet toLoad = new ObjectLinkedOpenHashSet();
        ReferenceLinkedOpenHashSet modulesToLoad = new ReferenceLinkedOpenHashSet();
        Configuration config = this.getConfiguration();
        config.load();
        config.addCustomCategoryComment(MODULE_CFG_CATEGORY_NAME, "Module configuration file. Can individually enable/disable modules from GregTech and its addons");
        for (IModuleContainer container : this.containers.values()) {
            String containerID = container.getID();
            List<IGregTechModule> containerModules = modules.get(containerID);
            IGregTechModule coreModule = ModuleManager.getCoreModule(containerModules);
            if (coreModule == null) {
                throw new IllegalStateException("Could not find core module for module container " + containerID);
            }
            containerModules.remove(coreModule);
            containerModules.add(0, coreModule);
            Iterator<IGregTechModule> iterator2 = containerModules.iterator();
            while (iterator2.hasNext()) {
                IGregTechModule module2 = iterator2.next();
                if (!this.isModuleEnabled(module2)) {
                    iterator2.remove();
                    logger.debug("Module disabled: {}", (Object)module2);
                    continue;
                }
                GregTechModule annotation = module2.getClass().getAnnotation(GregTechModule.class);
                toLoad.add(new ResourceLocation(containerID, annotation.moduleID()));
                modulesToLoad.add(module2);
            }
        }
        do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IGregTechModule)iterator.next();
                Set<ResourceLocation> dependencies = module.getDependencyUids();
                if (toLoad.containsAll(dependencies)) continue;
                iterator.remove();
                changed = true;
                GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
                String moduleID = annotation.moduleID();
                toLoad.remove(new ResourceLocation(moduleID));
                logger.info("Module {} is missing at least one of module dependencies: {}, skipping loading...", (Object)moduleID, dependencies);
            }
        } while (changed);
        block4: do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IGregTechModule)iterator.next();
                if (!this.sortedModules.keySet().containsAll(module.getDependencyUids())) continue;
                iterator.remove();
                GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
                this.sortedModules.put(new ResourceLocation(annotation.containerID(), annotation.moduleID()), module);
                changed = true;
                continue block4;
            }
        } while (changed);
        this.loadedModules.addAll(this.sortedModules.values());
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
    }

    @Nullable
    private static IGregTechModule getCoreModule(@NotNull Iterable<IGregTechModule> modules) {
        for (IGregTechModule module : modules) {
            GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
            if (!annotation.coreModule()) continue;
            return module;
        }
        return null;
    }

    @NotNull
    private static String getContainerID(@NotNull IGregTechModule module) {
        GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
        return annotation.containerID();
    }

    @NotNull
    private static Map<String, List<IGregTechModule>> getModules(@NotNull ASMDataTable table) {
        List<IGregTechModule> instances = ModuleManager.getInstances(table);
        Object2ReferenceLinkedOpenHashMap modules = new Object2ReferenceLinkedOpenHashMap();
        for (IGregTechModule module : instances) {
            GregTechModule info = module.getClass().getAnnotation(GregTechModule.class);
            modules.computeIfAbsent(info.containerID(), k -> new ArrayList()).add(module);
        }
        return modules;
    }

    @NotNull
    private static List<IGregTechModule> getInstances(@NotNull ASMDataTable table) {
        Set dataSet = table.getAll(GregTechModule.class.getCanonicalName());
        ArrayList<IGregTechModule> instances = new ArrayList<IGregTechModule>();
        for (ASMDataTable.ASMData data : dataSet) {
            String moduleID = (String)data.getAnnotationInfo().get("moduleID");
            List modDependencies = (List)data.getAnnotationInfo().get("modDependencies");
            if (modDependencies == null || modDependencies.stream().allMatch(Loader::isModLoaded)) {
                try {
                    Class<?> clazz = Class.forName(data.getClassName());
                    if (IGregTechModule.class.isAssignableFrom(clazz)) {
                        instances.add((IGregTechModule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        continue;
                    }
                    logger.error("Module of class {} with id {} is not an instanceof IGregTechModule", (Object)clazz.getName(), (Object)moduleID);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("Could not initialize module {}", (Object)moduleID, (Object)e);
                }
                continue;
            }
            logger.info("Module {} is missing at least one of mod dependencies: {}, skipping loading...", (Object)moduleID, (Object)modDependencies);
        }
        return instances.stream().sorted(Comparator.comparing(m -> m.getClass().getAnnotation(GregTechModule.class), Comparator.comparing(GregTechModule::containerID).thenComparing(GregTechModule::moduleID))).collect(Collectors.toList());
    }

    private void discoverContainers(@NotNull ASMDataTable table) {
        Set dataSet = table.getAll(ModuleContainer.class.getCanonicalName());
        for (ASMDataTable.ASMData data : dataSet) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (IGregTechModule.class.isAssignableFrom(clazz)) {
                    this.registerContainer((IModuleContainer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                logger.error("Module Container Class {} is not an instanceof IModuleContainer", (Object)clazz.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("Could not initialize module container {}", (Object)data.getClassName(), (Object)e);
            }
        }
    }

    private static String getComment(@NotNull IGregTechModule module) {
        String[] modDependencies;
        GregTechModule annotation = module.getClass().getAnnotation(GregTechModule.class);
        String comment = annotation.description();
        Set<ResourceLocation> dependencies = module.getDependencyUids();
        if (!dependencies.isEmpty()) {
            Iterator<ResourceLocation> iterator = dependencies.iterator();
            StringBuilder builder = new StringBuilder(comment);
            builder.append("\n");
            builder.append("Module Dependencies: [ ");
            builder.append(iterator.next());
            while (iterator.hasNext()) {
                builder.append(", ").append(iterator.next());
            }
            builder.append(" ]");
            comment = builder.toString();
        }
        if ((modDependencies = annotation.modDependencies()) != null && modDependencies.length > 0) {
            Iterator iterator = Arrays.stream(modDependencies).iterator();
            StringBuilder builder = new StringBuilder(comment);
            builder.append("\n");
            builder.append("Mod Dependencies: [ ");
            builder.append((String)iterator.next());
            while (iterator.hasNext()) {
                builder.append(", ").append((String)iterator.next());
            }
            builder.append(" ]");
            comment = builder.toString();
        }
        return comment;
    }

    @NotNull
    private Configuration getConfiguration() {
        if (this.config == null) {
            this.config = new Configuration(new File(configFolder, MODULE_CFG_FILE_NAME));
        }
        return this.config;
    }

    static {
        logger = LogManager.getLogger((String)"GregTech Module Loader");
    }
}

