/*
 * Decompiled with CFR 0.152.
 */
package gregtech.mixins.minecraft;

import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.util.Mods;
import gregtech.client.renderer.handler.LampItemOverlayRenderer;
import gregtech.client.utils.ToolChargeBarRenderer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderItem.class})
public class RenderItemMixin {
    @Inject(method={"renderItemOverlayIntoGUI"}, at={@At(value="HEAD")})
    private void renderItemOverlayIntoGUIInject(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, String text, CallbackInfo ci) {
        if (!stack.func_190926_b()) {
            RenderItemMixin.gregTechCEu$renderLampOverlay(stack, xPosition, yPosition);
        }
    }

    @Inject(method={"renderItemOverlayIntoGUI"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/Minecraft;getMinecraft()Lnet/minecraft/client/Minecraft;", shift=At.Shift.BEFORE, ordinal=0)})
    public void showDurabilityBarMixin(FontRenderer fr, ItemStack stack, int xPosition, int yPosition, String text, CallbackInfo ci) {
        if (!Mods.EnderCore.isModLoaded()) {
            RenderItemMixin.gregTechCEu$renderElectricBar(stack, xPosition, yPosition);
        }
    }

    @Unique
    private static void gregTechCEu$renderElectricBar(@NotNull ItemStack stack, int xPosition, int yPosition) {
        if (stack.func_77973_b() instanceof IGTTool) {
            ToolChargeBarRenderer.renderBarsTool((IGTTool)stack.func_77973_b(), stack, xPosition, yPosition);
        } else if (stack.func_77973_b() instanceof MetaItem) {
            ToolChargeBarRenderer.renderBarsItem((MetaItem)stack.func_77973_b(), stack, xPosition, yPosition);
        }
    }

    @Unique
    private static void gregTechCEu$renderLampOverlay(@NotNull ItemStack stack, int xPosition, int yPosition) {
        LampItemOverlayRenderer.OverlayType overlayType = LampItemOverlayRenderer.getOverlayType(stack);
        if (overlayType != LampItemOverlayRenderer.OverlayType.NONE) {
            LampItemOverlayRenderer.renderOverlay(overlayType, xPosition, yPosition);
        }
    }
}

