/*
 * Decompiled with CFR 0.152.
 */
package gregtech.mixins.minecraft;

import gregtech.api.items.armor.IArmorItem;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LayerArmorBase.class})
public class LayerArmorBaseMixin {
    @Inject(method={"renderArmorLayer"}, at={@At(value="TAIL")})
    public void renderGTArmor(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn, CallbackInfo ci) {
        ItemStack itemStack = entityLivingBaseIn.func_184582_a(slotIn);
        Item item = itemStack.func_77973_b();
        if (item instanceof IArmorItem) {
            IArmorItem armorItem = (IArmorItem)item;
            if (itemStack.func_77973_b().getEquipmentSlot(itemStack) == slotIn) {
                LayerArmorBase layer = (LayerArmorBase)this;
                ModelBase armorModel = layer.func_188360_a(slotIn);
                if (armorModel instanceof ModelBiped) {
                    armorModel = ForgeHooksClient.getArmorModel((EntityLivingBase)entityLivingBaseIn, (ItemStack)itemStack, (EntityEquipmentSlot)slotIn, (ModelBiped)((ModelBiped)armorModel));
                }
                armorModel.func_178686_a(layer.field_177190_a.func_177087_b());
                armorModel.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
                layer.func_188359_a(armorModel, slotIn);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                int layers = armorItem.getArmorLayersAmount(itemStack);
                for (int layerIndex = 0; layerIndex < layers; ++layerIndex) {
                    int i = armorItem.getArmorLayerColor(itemStack, layerIndex);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)1.0f);
                    String type = layerIndex == 0 ? null : "layer_" + layerIndex;
                    layer.field_177190_a.func_110776_a(LayerArmorBaseMixin.gregTechCEu$getArmorTexture(entityLivingBaseIn, itemStack, slotIn, type));
                    armorModel.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                }
                if (itemStack.func_77962_s()) {
                    LayerArmorBase.func_188364_a((RenderLivingBase)layer.field_177190_a, (EntityLivingBase)entityLivingBaseIn, (ModelBase)armorModel, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
                }
            }
        }
    }

    @Unique
    private static ResourceLocation gregTechCEu$getArmorTexture(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, String type) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        if (registryName == null) {
            throw new IllegalArgumentException("ItemStack " + itemStack.func_77977_a() + "has a null registry name");
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", registryName.func_110624_b(), registryName.func_110623_a(), slot == EntityEquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format("_%s", type));
        return new ResourceLocation(ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)itemStack, (String)s1, (EntityEquipmentSlot)slot, (String)type));
    }
}

