/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe.handlers;

import gregtech.api.GTValues;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterial;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.DyeUtil;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.AbstractMaterialPartBehavior;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;

public class PartsRecipeHandler {
    private PartsRecipeHandler() {
    }

    public static void register() {
        OrePrefix.stick.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processStick);
        OrePrefix.stickLong.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processLongStick);
        OrePrefix.plate.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processPlate);
        OrePrefix.plateDouble.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processPlateDouble);
        OrePrefix.plateDense.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processPlateDense);
        OrePrefix.turbineBlade.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processTurbine);
        OrePrefix.rotor.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRotor);
        OrePrefix.bolt.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processBolt);
        OrePrefix.screw.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processScrew);
        OrePrefix.wireFine.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processFineWire);
        OrePrefix.foil.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processFoil);
        OrePrefix.lens.addProcessingHandler(PropertyKey.GEM, PartsRecipeHandler::processLens);
        OrePrefix.gear.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processGear);
        OrePrefix.gearSmall.addProcessingHandler(PropertyKey.DUST, PartsRecipeHandler::processGear);
        OrePrefix.ring.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRing);
        OrePrefix.springSmall.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processSpringSmall);
        OrePrefix.spring.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processSpring);
        OrePrefix.round.addProcessingHandler(PropertyKey.INGOT, PartsRecipeHandler::processRound);
    }

    public static void processBolt(OrePrefix boltPrefix, Material material, DustProperty property) {
        ItemStack boltStack = OreDictUnifier.get(boltPrefix, material);
        ItemStack ingotStack = OreDictUnifier.get(OrePrefix.ingot, material);
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(OrePrefix.screw, material)).outputs(boltStack)).duration(20)).EUt(GTUtility.scaleVoltage(24L, workingTier))).buildAndRegister();
        if (!boltStack.func_190926_b() && !ingotStack.func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).outputs(GTUtility.copy(8, boltStack))).duration(15)).EUt(GTUtility.scaleVoltage(GTValues.VA[2], workingTier))).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_BOLT)).outputs(GTUtility.copy(8, boltStack))).duration(15)).EUt(GTUtility.scaleVoltage(GTValues.VA[2], workingTier))).buildAndRegister();
            }
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_BOLT)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(18))).output(boltPrefix, material)).EUt(GTUtility.scaleVoltage(GTValues.VA[2], workingTier))).duration(2)).buildAndRegister();
        }
    }

    public static void processScrew(OrePrefix screwPrefix, Material material, DustProperty property) {
        ItemStack screwStack = OreDictUnifier.get(screwPrefix, material);
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.bolt, material)).outputs(screwStack)).duration((int)Math.max(1L, material.getMass() / 8L))).EUt(GTUtility.scaleVoltage(4L, workingTier))).buildAndRegister();
        if (workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("screw_%s", material), screwStack, "fX", "X ", Character.valueOf('X'), new UnificationEntry(OrePrefix.bolt, material));
        }
    }

    public static void processFoil(OrePrefix foilPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (!material.hasFlag(MaterialFlags.NO_SMASHING) && workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("foil_%s", material), OreDictUnifier.get(foilPrefix, material, 2), "hP ", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(24L, workingTier))).circuitMeta(1)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(24L, workingTier))).circuitMeta(10)).buildAndRegister();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_FOIL)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(24L, workingTier))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_FOIL)).output(foilPrefix, material, 4)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(24L, workingTier))).buildAndRegister();
        }
    }

    public static void processFineWire(OrePrefix fineWirePrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (!OreDictUnifier.get(OrePrefix.foil, material).func_190926_b() && workingTier <= 3) {
            ModHandler.addShapelessRecipe(String.format("fine_wire_%s", material.toString()), OreDictUnifier.get(fineWirePrefix, material), Character.valueOf('x'), new UnificationEntry(OrePrefix.foil, material));
        }
        if (material.hasProperty(PropertyKey.WIRE)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.wireGtSingle, material)).circuitMeta(1)).output(fineWirePrefix, material, 4)).duration((int)material.getMass() * 3 / 2)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.WIREMILL_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).circuitMeta(3)).output(fineWirePrefix, material, 8)).duration((int)material.getMass() * 2)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).buildAndRegister();
    }

    public static void processGear(OrePrefix gearPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        ItemStack stack = OreDictUnifier.get(gearPrefix, material);
        if (gearPrefix == OrePrefix.gear && material.hasProperty(PropertyKey.INGOT)) {
            long voltageMultiplier = PartsRecipeHandler.getVoltageMultiplier(material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 5)).EUt(GTUtility.scaleVoltage(8L * voltageMultiplier, workingTier))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 8)).notConsumable(MetaItems.SHAPE_MOLD_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 10)).EUt(GTUtility.scaleVoltage(2L * voltageMultiplier, workingTier))).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR)).outputs(OreDictUnifier.get(gearPrefix, material))).duration((int)material.getMass() * 5)).EUt(GTUtility.scaleVoltage(8L * voltageMultiplier, workingTier))).buildAndRegister();
            }
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            boolean isSmall = gearPrefix == OrePrefix.gearSmall;
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(isSmall ? MetaItems.SHAPE_MOLD_GEAR_SMALL : MetaItems.SHAPE_MOLD_GEAR)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(144 * (isSmall ? 1 : 4)))).outputs(stack)).duration(isSmall ? 20 : 100)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            if (gearPrefix == OrePrefix.gearSmall) {
                if (workingTier <= 3) {
                    ModHandler.addShapedRecipe(String.format("small_gear_%s", material), OreDictUnifier.get(OrePrefix.gearSmall, material), " R ", "hPx", " R ", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
                }
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR_SMALL)).outputs(stack)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(material.getBlastTemperature() >= 2800 ? 256L : 64L, workingTier))).buildAndRegister();
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ALLOY_SMELTER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 2)).notConsumable(MetaItems.SHAPE_MOLD_GEAR_SMALL.getStackForm())).output(OrePrefix.gearSmall, material)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(GTValues.VA[1], workingTier))).buildAndRegister();
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_GEAR_SMALL)).outputs(stack)).duration((int)material.getMass())).EUt(GTUtility.scaleVoltage(material.getBlastTemperature() >= 2800 ? 256L : 64L, workingTier))).buildAndRegister();
                }
            } else if (workingTier <= 3) {
                ModHandler.addShapedRecipe(String.format("gear_%s", material), stack, "RPR", "PwP", "RPR", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
            }
        }
    }

    public static void processLens(OrePrefix lensPrefix, Material material, GemProperty property) {
        ItemStack stack = OreDictUnifier.get(lensPrefix, material);
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.plate, material)).output(OrePrefix.lens, material)).output(OrePrefix.dustSmall, material)).duration(1200)).EUt(GTUtility.scaleVoltage(GTValues.VA[2], workingTier))).buildAndRegister();
        if (!OreDictUnifier.get(OrePrefix.gemExquisite, material).func_190926_b()) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.gemExquisite, material)).output(OrePrefix.lens, material)).output(OrePrefix.dust, material, 2)).duration(2400)).EUt(GTUtility.scaleVoltage(GTValues.VA[1], workingTier))).buildAndRegister();
        }
        if (material == Materials.Diamond) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.LightBlue);
        } else if (material == Materials.Ruby) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Red);
        } else if (material == Materials.Emerald) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)MarkerMaterials.Color.Green);
        } else if (material == Materials.Glass) {
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens.name() + material.toCamelCaseString());
        } else {
            EnumDyeColor dyeColor = DyeUtil.determineDyeColor(material.getMaterialRGB());
            MarkerMaterial colorMaterial = (MarkerMaterial)MarkerMaterials.Color.COLORS.get((Object)dyeColor);
            OreDictUnifier.registerOre(stack, OrePrefix.craftingLens, (Material)colorMaterial);
        }
    }

    public static void processPlate(OrePrefix platePrefix, Material material, DustProperty property) {
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_PLATE)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(144))).outputs(OreDictUnifier.get(platePrefix, material))).duration(40)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], material.getWorkingTier()))).buildAndRegister();
        }
    }

    public static void processPlateDouble(OrePrefix doublePrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE)) {
            if (!material.hasFlag(MaterialFlags.NO_SMASHING) && workingTier <= 3) {
                ModHandler.addShapedRecipe(String.format("plate_double_%s", material), OreDictUnifier.get(doublePrefix, material), "h", "P", "P", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, material));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 2)).output(doublePrefix, material)).circuitMeta(2)).duration((int)material.getMass() * 2)).EUt(GTUtility.scaleVoltage(96L, workingTier))).buildAndRegister();
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 2)).circuitMeta(2)).output(doublePrefix, material)).duration((int)material.getMass() * 2)).EUt(GTUtility.scaleVoltage(96L, workingTier))).buildAndRegister();
        }
    }

    public static void processPlateDense(OrePrefix orePrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.plate, material, 9)).circuitMeta(9)).output(orePrefix, material)).duration((int)Math.max(material.getMass() * 9L, 1L))).EUt(GTUtility.scaleVoltage(96L, workingTier))).buildAndRegister();
        if (material.hasProperty(PropertyKey.INGOT)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 9)).circuitMeta(9)).output(orePrefix, material)).duration((int)Math.max(material.getMass() * 9L, 1L))).EUt(GTUtility.scaleVoltage(96L, workingTier))).buildAndRegister();
        }
    }

    public static void processRing(OrePrefix ringPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_RING)).outputs(OreDictUnifier.get(ringPrefix, material, 4))).duration((int)material.getMass() * 2)).EUt(GTUtility.scaleVoltage(6L * PartsRecipeHandler.getVoltageMultiplier(material), workingTier))).buildAndRegister();
        if (!material.hasFlag(MaterialFlags.NO_SMASHING)) {
            if (workingTier <= 3) {
                ModHandler.addShapedRecipe(String.format("ring_%s", material), OreDictUnifier.get(ringPrefix, material), "h ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
            }
        } else {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_RING)).outputs(OreDictUnifier.get(ringPrefix, material, 4))).duration((int)material.getMass() * 2)).EUt(GTUtility.scaleVoltage(6L * PartsRecipeHandler.getVoltageMultiplier(material), workingTier))).buildAndRegister();
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_RING)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(36))).output(ringPrefix, material)).EUt(GTUtility.scaleVoltage(6L * PartsRecipeHandler.getVoltageMultiplier(material), workingTier))).duration((int)Math.max((float)material.getMass() / 2.0f * 0.95f, 1.0f))).buildAndRegister();
        }
    }

    public static void processSpringSmall(OrePrefix springPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("spring_small_%s", material.toString()), OreDictUnifier.get(OrePrefix.springSmall, material), " s ", "fRx", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.stick, material)).output(OrePrefix.springSmall, material, 2)).circuitMeta(1)).duration((int)(material.getMass() / 2L))).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).buildAndRegister();
    }

    public static void processSpring(OrePrefix springPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.BENDER_RECIPES.recipeBuilder().input(OrePrefix.stickLong, material)).outputs(OreDictUnifier.get(OrePrefix.spring, material))).circuitMeta(1)).duration(200)).EUt(GTUtility.scaleVoltage(16L, workingTier))).buildAndRegister();
        if (workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("spring_%s", material.toString()), OreDictUnifier.get(OrePrefix.spring, material), " s ", "fRx", " R ", Character.valueOf('R'), new UnificationEntry(OrePrefix.stickLong, material));
        }
    }

    public static void processRotor(OrePrefix rotorPrefix, Material material, IngotProperty property) {
        ItemStack stack = OreDictUnifier.get(rotorPrefix, material);
        int workingTier = material.getWorkingTier();
        if (workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("rotor_%s", material.toString()), stack, "ChC", "SRf", "CdC", Character.valueOf('C'), new UnificationEntry(OrePrefix.plate, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, material));
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_ROTOR)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(576))).outputs(GTUtility.copy(stack))).duration(120)).EUt(GTUtility.scaleVoltage(20L, workingTier))).buildAndRegister();
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROTOR)).outputs(GTUtility.copy(stack))).duration((int)material.getMass() * 4)).EUt(GTUtility.scaleVoltage(material.getBlastTemperature() >= 2800 ? 256L : 64L, workingTier))).buildAndRegister();
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material, 4)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROTOR)).outputs(GTUtility.copy(stack))).duration((int)material.getMass() * 4)).EUt(GTUtility.scaleVoltage(material.getBlastTemperature() >= 2800 ? 256L : 64L, workingTier))).buildAndRegister();
        }
    }

    public static void processStick(OrePrefix stickPrefix, Material material, DustProperty property) {
        int workingTier = material.getWorkingTier();
        if (material.hasProperty(PropertyKey.GEM) || material.hasProperty(PropertyKey.INGOT)) {
            Object builder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(material.hasProperty(PropertyKey.GEM) ? OrePrefix.gem : OrePrefix.ingot, material)).duration((int)Math.max(material.getMass() * 2L, 1L))).EUt(GTUtility.scaleVoltage(16L, workingTier));
            if (ConfigHolder.recipes.harderRods) {
                ((RecipeBuilder)builder).output(OrePrefix.stick, material);
                ((RecipeBuilder)builder).output(OrePrefix.dustSmall, material, 2);
            } else {
                ((RecipeBuilder)builder).output(OrePrefix.stick, material, 2);
            }
            ((RecipeBuilder)builder).buildAndRegister();
        }
        if (material.hasFlag(MaterialFlags.GENERATE_BOLT_SCREW)) {
            ItemStack boltStack = OreDictUnifier.get(OrePrefix.bolt, material);
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(stickPrefix, material)).outputs(GTUtility.copy(4, boltStack))).duration((int)Math.max(material.getMass() * 2L, 1L))).EUt(GTUtility.scaleVoltage(4L, workingTier))).buildAndRegister();
            if (workingTier <= 3) {
                ModHandler.addShapedRecipe(String.format("bolt_saw_%s", material), GTUtility.copy(2, boltStack), "s ", " X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stick, material));
            }
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_ROD)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(72))).output(stickPrefix, material)).EUt(GTUtility.scaleVoltage(6L * PartsRecipeHandler.getVoltageMultiplier(material), workingTier))).duration((int)Math.max((float)material.getMass() * 0.95f, 1.0f))).buildAndRegister();
        }
    }

    public static void processLongStick(OrePrefix longStickPrefix, Material material, DustProperty property) {
        ItemStack stack = OreDictUnifier.get(longStickPrefix, material);
        ItemStack stickStack = OreDictUnifier.get(OrePrefix.stick, material);
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().input(longStickPrefix, material)).outputs(GTUtility.copy(2, stickStack))).duration((int)Math.max(material.getMass(), 1L))).EUt(GTUtility.scaleVoltage(4L, workingTier))).buildAndRegister();
        if (workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("stick_long_%s", material), GTUtility.copy(2, stickStack), "s", "X", Character.valueOf('X'), new UnificationEntry(OrePrefix.stickLong, material));
            if (material.hasProperty(PropertyKey.GEM)) {
                ModHandler.addShapedRecipe(String.format("stick_long_gem_flawless_%s", material), stickStack, "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemFlawless, material));
                ModHandler.addShapedRecipe(String.format("stick_long_gem_exquisite_%s", material), GTUtility.copy(2, stickStack), "sf", "G ", Character.valueOf('G'), new UnificationEntry(OrePrefix.gemExquisite, material));
            }
            ModHandler.addShapedRecipe(String.format("stick_long_stick_%s", material), stack, "ShS", Character.valueOf('S'), new UnificationEntry(OrePrefix.stick, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORGE_HAMMER_RECIPES.recipeBuilder().input(OrePrefix.stick, material, 2)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(GTUtility.scaleVoltage(16L, workingTier))).buildAndRegister();
        if (material.hasProperty(PropertyKey.INGOT)) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.ingot, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD_LONG)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(GTUtility.scaleVoltage(64L, workingTier))).buildAndRegister();
            if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRUDER_RECIPES.recipeBuilder().input(OrePrefix.dust, material)).notConsumable(MetaItems.SHAPE_EXTRUDER_ROD_LONG)).outputs(stack)).duration((int)Math.max(material.getMass(), 1L))).EUt(GTUtility.scaleVoltage(64L, workingTier))).buildAndRegister();
            }
        }
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_ROD_LONG)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(144))).output(longStickPrefix, material)).EUt(GTUtility.scaleVoltage(64L, workingTier))).duration((int)Math.max((float)material.getMass() * 0.95f, 1.0f))).buildAndRegister();
        }
    }

    public static void processTurbine(OrePrefix toolPrefix, Material material, IngotProperty property) {
        ItemStack rotorStack = MetaItems.TURBINE_ROTOR.getStackForm();
        AbstractMaterialPartBehavior.setPartMaterial(rotorStack, material);
        int workingTier = material.getWorkingTier();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().input(OrePrefix.turbineBlade, material, 8)).input(OrePrefix.stickLong, Materials.Magnalium)).outputs(rotorStack)).duration(200)).EUt(400L)).buildAndRegister();
        boolean hasDoublePlate = OrePrefix.plateDouble.doGenerateItem(material);
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FORMING_PRESS_RECIPES.recipeBuilder().input(hasDoublePlate ? OrePrefix.plateDouble : OrePrefix.plate, material, hasDoublePlate ? 5 : 10)).input(OrePrefix.screw, material, 2)).outputs(OreDictUnifier.get(toolPrefix, material))).duration(20)).EUt(GTUtility.scaleVoltage(256L, workingTier))).buildAndRegister();
        if (hasDoublePlate && workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("turbine_blade_%s", material), OreDictUnifier.get(toolPrefix, material), "PPP", "SPS", "fPd", Character.valueOf('P'), new UnificationEntry(OrePrefix.plateDouble, material), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, material));
        }
    }

    public static void processRound(OrePrefix roundPrefix, Material material, IngotProperty property) {
        int workingTier = material.getWorkingTier();
        if (!material.hasFlag(MaterialFlags.NO_SMASHING) && workingTier <= 3) {
            ModHandler.addShapedRecipe(String.format("round_%s", material), OreDictUnifier.get(OrePrefix.round, material), "fN", "Nh", Character.valueOf('N'), new UnificationEntry(OrePrefix.nugget, material));
            ModHandler.addShapedRecipe(String.format("round_from_ingot_%s", material), OreDictUnifier.get(OrePrefix.round, material, 4), "fIh", Character.valueOf('I'), new UnificationEntry(OrePrefix.ingot, material));
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.LATHE_RECIPES.recipeBuilder().input(OrePrefix.nugget, material)).output(OrePrefix.round, material)).duration(100)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).buildAndRegister();
        if (material.hasFluid() && material.getProperty(PropertyKey.FLUID).solidifiesFrom() != null) {
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.FLUID_SOLIDFICATION_RECIPES.recipeBuilder().notConsumable(MetaItems.SHAPE_MOLD_ROUND)).fluidInputs(material.getProperty(PropertyKey.FLUID).solidifiesFrom(16))).output(roundPrefix, material)).EUt(GTUtility.scaleVoltage(GTValues.VA[0], workingTier))).duration(90)).buildAndRegister();
        }
    }

    private static long getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() > 2800 ? (long)GTValues.VA[1] : (long)GTValues.VA[0];
    }
}

