/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.RecyclingData;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.common.items.MetaItems;
import gregtech.loaders.WoodTypeEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jetbrains.annotations.NotNull;

public class WoodRecipeLoader {
    private static List<WoodTypeEntry> DEFAULT_ENTRIES;

    private static List<WoodTypeEntry> getDefaultEntries() {
        if (DEFAULT_ENTRIES == null) {
            String mcModId = "minecraft";
            DEFAULT_ENTRIES = Arrays.asList(new WoodTypeEntry.Builder("minecraft", "oak").planks(new ItemStack(Blocks.field_150344_f), "oak_planks").log(new ItemStack(Blocks.field_150364_r)).removeCharcoalRecipe().door(new ItemStack(Items.field_179570_aq), "wooden_door").slab(new ItemStack((Block)Blocks.field_150376_bx), "oak_wooden_slab").fence(new ItemStack(Blocks.field_180407_aO), "fence").fenceGate(new ItemStack(Blocks.field_180390_bo), "fence_gate").stairs(new ItemStack(Blocks.field_150476_ad), "oak_stairs").boat(new ItemStack(Items.field_151124_az), "boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "spruce").planks(new ItemStack(Blocks.field_150344_f, 1, 1), "spruce_planks").log(new ItemStack(Blocks.field_150364_r, 1, 1)).removeCharcoalRecipe().door(new ItemStack(Items.field_179569_ar), "spruce_door").slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 1), "spruce_wooden_slab").fence(new ItemStack(Blocks.field_180408_aP), "spruce_fence").fenceGate(new ItemStack(Blocks.field_180391_bp), "spruce_fence_gate").stairs(new ItemStack(Blocks.field_150485_bF), "spruce_stairs").boat(new ItemStack(Items.field_185150_aH), "spruce_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "birch").planks(new ItemStack(Blocks.field_150344_f, 1, 2), "birch_planks").log(new ItemStack(Blocks.field_150364_r, 1, 2)).removeCharcoalRecipe().door(new ItemStack(Items.field_179568_as), "birch_door").slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 2), "birch_wooden_slab").fence(new ItemStack(Blocks.field_180404_aQ), "birch_fence").fenceGate(new ItemStack(Blocks.field_180392_bq), "birch_fence_gate").stairs(new ItemStack(Blocks.field_150487_bG), "birch_stairs").boat(new ItemStack(Items.field_185151_aI), "birch_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "jungle").planks(new ItemStack(Blocks.field_150344_f, 1, 3), "jungle_planks").log(new ItemStack(Blocks.field_150364_r, 1, 3)).removeCharcoalRecipe().door(new ItemStack(Items.field_179567_at), "jungle_door").slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 3), "jungle_wooden_slab").fence(new ItemStack(Blocks.field_180403_aR), "jungle_fence").fenceGate(new ItemStack(Blocks.field_180386_br), "jungle_fence_gate").stairs(new ItemStack(Blocks.field_150481_bH), "jungle_stairs").boat(new ItemStack(Items.field_185152_aJ), "jungle_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "acacia").planks(new ItemStack(Blocks.field_150344_f, 1, 4), "acacia_planks").log(new ItemStack(Blocks.field_150363_s)).removeCharcoalRecipe().door(new ItemStack(Items.field_179572_au), "acacia_door").slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 4), "acacia_wooden_slab").fence(new ItemStack(Blocks.field_180405_aT), "acacia_fence").fenceGate(new ItemStack(Blocks.field_180387_bt), "acacia_fence_gate").stairs(new ItemStack(Blocks.field_150400_ck), "acacia_stairs").boat(new ItemStack(Items.field_185153_aK), "acacia_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("minecraft", "dark_oak").planks(new ItemStack(Blocks.field_150344_f, 1, 5), "dark_oak_planks").log(new ItemStack(Blocks.field_150363_s, 1, 1)).removeCharcoalRecipe().door(new ItemStack(Items.field_179571_av), "dark_oak_door").slab(new ItemStack((Block)Blocks.field_150376_bx, 1, 5), "dark_oak_wooden_slab").fence(new ItemStack(Blocks.field_180406_aS), "dark_oak_fence").fenceGate(new ItemStack(Blocks.field_180385_bs), "dark_oak_fence_gate").stairs(new ItemStack(Blocks.field_150401_cl), "dark_oak_stairs").boat(new ItemStack(Items.field_185154_aL), "dark_oak_boat").registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("gregtech", "rubber").planks(MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.RUBBER_PLANK), null).log(new ItemStack((Block)MetaBlocks.RUBBER_LOG)).addCharcoalRecipe().door(MetaItems.RUBBER_WOOD_DOOR.getStackForm(), null).slab(new ItemStack((Block)MetaBlocks.WOOD_SLAB), null).addSlabRecipe().fence(new ItemStack((Block)MetaBlocks.RUBBER_WOOD_FENCE), null).fenceGate(new ItemStack((Block)MetaBlocks.RUBBER_WOOD_FENCE_GATE), null).stairs(new ItemStack((Block)MetaBlocks.RUBBER_WOOD_STAIRS), null).addStairsRecipe().boat(MetaItems.RUBBER_WOOD_BOAT.getStackForm(), null).registerAllOres().registerAllUnificationInfo().build(), new WoodTypeEntry.Builder("gregtech", "treated").planks(MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK), null).door(MetaItems.TREATED_WOOD_DOOR.getStackForm(), null).slab(new ItemStack((Block)MetaBlocks.WOOD_SLAB, 1, 1), null).addSlabRecipe().fence(new ItemStack((Block)MetaBlocks.TREATED_WOOD_FENCE), null).fenceGate(new ItemStack((Block)MetaBlocks.TREATED_WOOD_FENCE_GATE), null).stairs(new ItemStack((Block)MetaBlocks.TREATED_WOOD_STAIRS), null).addStairsRecipe().boat(MetaItems.TREATED_WOOD_BOAT.getStackForm(), null).material(Materials.TreatedWood).registerAllOres().registerAllUnificationInfo().build());
            return DEFAULT_ENTRIES;
        }
        return DEFAULT_ENTRIES;
    }

    public static void registerUnificationInfo() {
        for (WoodTypeEntry entry : WoodRecipeLoader.getDefaultEntries()) {
            WoodRecipeLoader.registerWoodUnificationInfo(entry);
        }
    }

    public static void registerRecipes() {
        WoodRecipeLoader.registerGTWoodRecipes();
        WoodRecipeLoader.registerWoodRecipes();
        WoodRecipeLoader.registerPyrolyseOvenRecipes();
    }

    private static void registerWoodRecipes() {
        for (WoodTypeEntry entry : WoodRecipeLoader.getDefaultEntries()) {
            WoodRecipeLoader.registerWoodTypeRecipe(entry);
        }
    }

    public static void registerWoodUnificationInfo(@NotNull WoodTypeEntry entry) {
        if (!entry.log.func_190926_b() && entry.addLogOreDict) {
            OreDictUnifier.registerOre(entry.log, OrePrefix.log, entry.material);
        }
        if (entry.addPlanksOreDict) {
            OreDictUnifier.registerOre(entry.planks, OrePrefix.plank, entry.material);
        }
        if (entry.addPlanksUnificationInfo) {
            GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.planks, new RecyclingData(new MaterialStack(entry.material, 3628800L)));
        }
        if (!entry.door.func_190926_b()) {
            if (entry.addDoorsOreDict) {
                OreDictUnifier.registerOre(entry.door, OrePrefix.door, entry.material);
            }
            if (entry.addDoorsUnificationInfo) {
                GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.door, ConfigHolder.recipes.hardWoodRecipes ? new RecyclingData(new MaterialStack(entry.material, 7257600L), new MaterialStack(Materials.Iron, 403200L)) : new RecyclingData(new MaterialStack(entry.material, 7257600L)));
            }
        }
        if (!entry.slab.func_190926_b()) {
            if (entry.addSlabsOreDict) {
                OreDictUnifier.registerOre(entry.slab, OrePrefix.slab, entry.material);
            }
            if (entry.addSlabsUnificationInfo) {
                GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.slab, new RecyclingData(new MaterialStack(entry.material, 1814400L)));
            }
        }
        if (!entry.fence.func_190926_b()) {
            if (entry.addFencesOreDict) {
                OreDictUnifier.registerOre(entry.fence, OrePrefix.fence, entry.material);
            }
            if (entry.addFencesUnificationInfo) {
                GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.fence, new RecyclingData(new MaterialStack(entry.material, 3628800L)));
            }
        }
        if (!entry.fenceGate.func_190926_b()) {
            if (entry.addFenceGatesOreDict) {
                OreDictUnifier.registerOre(entry.fenceGate, OrePrefix.fenceGate, entry.material);
            }
            if (entry.addFenceGatesUnificationInfo) {
                GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.fenceGate, new RecyclingData(new MaterialStack(entry.material, 10886400L)));
            }
        }
        if (!entry.stairs.func_190926_b()) {
            if (entry.addStairsOreDict) {
                OreDictUnifier.registerOre(entry.stairs, OrePrefix.stair, entry.material);
            }
            if (entry.addStairsUnificationInfo) {
                GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.stairs, new RecyclingData(new MaterialStack(entry.material, 5443200L)));
            }
        }
        if (!entry.boat.func_190926_b() && entry.addBoatsUnificationInfo) {
            GregTechAPI.RECYCLING_MANAGER.registerRecyclingData(entry.boat, new RecyclingData(new MaterialStack(entry.material, 18144000L)));
        }
    }

    public static void registerWoodTypeRecipe(@NotNull WoodTypeEntry entry) {
        String name = entry.woodName;
        if (entry.planks.func_190926_b()) {
            throw new IllegalStateException("Could not find planks form of WoodTypeEntry '" + name + "'.");
        }
        if (!entry.log.func_190926_b()) {
            boolean hasPlanksRecipe;
            boolean bl = hasPlanksRecipe = entry.planksRecipeName != null;
            if (ConfigHolder.recipes.nerfWoodCrafting) {
                if (hasPlanksRecipe) {
                    ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.planksRecipeName));
                }
                ModHandler.addShapelessRecipe(hasPlanksRecipe ? entry.planksRecipeName : name + "_planks", GTUtility.copy(2, entry.planks), entry.log.func_77946_l());
            } else if (!hasPlanksRecipe) {
                ModHandler.addShapelessRecipe(name + "_planks", GTUtility.copy(4, entry.planks), entry.log.func_77946_l());
            }
            ModHandler.addShapedRecipe(name + "_planks_saw", GTUtility.copy(ConfigHolder.recipes.nerfWoodCrafting ? 4 : 6, entry.planks), "s", "L", Character.valueOf('L'), entry.log.func_77946_l());
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(entry.log.func_77946_l())).outputs(GTUtility.copy(6, entry.planks))).output(OrePrefix.dust, Materials.Wood, 2)).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
            if (ConfigHolder.recipes.harderCharcoalRecipe) {
                ItemStack outputStack;
                if (entry.removeCharcoalRecipe && (outputStack = FurnaceRecipes.func_77602_a().func_151395_a(entry.log)).func_77973_b() == Items.field_151044_h && outputStack.func_77952_i() == 1) {
                    ModHandler.removeFurnaceSmelting(entry.log);
                }
            } else if (entry.addCharcoalRecipe) {
                GameRegistry.addSmelting((Block)MetaBlocks.RUBBER_LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
            }
        }
        if (!entry.door.func_190926_b()) {
            boolean hasDoorRecipe;
            boolean bl = hasDoorRecipe = entry.doorRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasDoorRecipe) {
                    ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.doorRecipeName));
                }
                ModHandler.addShapedRecipe(hasDoorRecipe ? entry.doorRecipeName : name + "_door", entry.door.func_77946_l(), "PTd", "PRS", "PPs", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('T'), new ItemStack(Blocks.field_150415_aT), Character.valueOf('R'), new UnificationEntry(OrePrefix.ring, Materials.Iron), Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron));
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(new ItemStack(Blocks.field_150415_aT))).inputs(GTUtility.copy(4, entry.planks))).fluidInputs(Materials.Iron.getFluid(16))).outputs(entry.door.func_77946_l())).duration(400)).EUt(4L)).buildAndRegister();
            } else {
                if (!hasDoorRecipe) {
                    ModHandler.addShapedRecipe(name + "_door", GTUtility.copy(3, entry.door), "PP", "PP", "PP", Character.valueOf('P'), entry.planks.func_77946_l());
                }
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copy(6, entry.planks))).outputs(GTUtility.copy(3, entry.door))).circuitMeta(6)).duration(600)).EUt(4L)).buildAndRegister();
            }
        }
        if (!entry.stairs.func_190926_b()) {
            boolean hasStairRecipe;
            boolean bl = hasStairRecipe = entry.stairsRecipeName != null;
            if (entry.addStairsCraftingRecipe) {
                ModHandler.addShapedRecipe(hasStairRecipe ? entry.stairsRecipeName : name + "_stairs", GTUtility.copy(4, entry.stairs), "P  ", "PP ", "PPP", Character.valueOf('P'), entry.planks.func_77946_l());
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copy(6, entry.planks))).outputs(GTUtility.copy(4, entry.stairs))).circuitMeta(7)).EUt(1L)).duration(100)).buildAndRegister();
        }
        if (!entry.slab.func_190926_b()) {
            if (entry.addSlabCraftingRecipe && !ConfigHolder.recipes.hardWoodRecipes) {
                ModHandler.addShapedRecipe(name + "_slab", GTUtility.copy(6, entry.slab), "PPP", Character.valueOf('P'), entry.planks.func_77946_l());
            }
            ModHandler.addShapedRecipe(name + "_slab_saw", GTUtility.copy(2, entry.slab), "sS", Character.valueOf('S'), entry.planks.func_77946_l());
            if (ConfigHolder.recipes.hardWoodRecipes && entry.slabRecipeName != null) {
                ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.slabRecipeName));
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.CUTTER_RECIPES.recipeBuilder().inputs(entry.planks.func_77946_l())).outputs(GTUtility.copy(2, entry.slab))).duration(200)).EUt(GTValues.VA[0])).buildAndRegister();
        }
        if (!entry.fence.func_190926_b()) {
            boolean hasFenceRecipe;
            boolean bl = hasFenceRecipe = entry.fenceRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasFenceRecipe) {
                    ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.fenceRecipeName));
                }
                ModHandler.addShapedRecipe(hasFenceRecipe ? entry.fenceRecipeName : name + "_fence", entry.fence.func_77946_l(), "PSP", "PSP", "PSP", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick());
            } else if (!hasFenceRecipe) {
                ModHandler.addShapedRecipe(name + "_fence", GTUtility.copy(3, entry.fence), "PSP", "PSP", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick());
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(entry.planks.func_77946_l())).outputs(entry.fence.func_77946_l())).circuitMeta(1)).duration(100)).EUt(4L)).buildAndRegister();
        }
        if (!entry.fenceGate.func_190926_b()) {
            boolean hasFenceGateRecipe;
            boolean bl = hasFenceGateRecipe = entry.fenceGateRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (hasFenceGateRecipe) {
                    ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.fenceGateRecipeName));
                }
                ModHandler.addShapedRecipe(hasFenceGateRecipe ? entry.fenceGateRecipeName : name + "_fence_gate", entry.fenceGate.func_77946_l(), "F F", "SPS", "SPS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick(), Character.valueOf('F'), new ItemStack(Items.field_151145_ak));
                ModHandler.addShapedRecipe(name + "_fence_gate_screws", GTUtility.copy(2, entry.fenceGate), "IdI", "SPS", "SPS", Character.valueOf('P'), entry.planks, Character.valueOf('S'), entry.getStick(), Character.valueOf('I'), new UnificationEntry(OrePrefix.screw, Materials.Iron));
            } else if (!hasFenceGateRecipe) {
                ModHandler.addShapedRecipe(name + "_fence_gate", entry.fenceGate.func_77946_l(), "SPS", "SPS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.getStick());
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copy(2, entry.planks))).input(entry.getStick().toString(), 2)).outputs(entry.fenceGate.func_77946_l())).circuitMeta(2)).duration(100)).EUt(4L)).buildAndRegister();
        }
        if (!entry.boat.func_190926_b()) {
            boolean hasBoatRecipe;
            boolean bl = hasBoatRecipe = entry.boatRecipeName != null;
            if (ConfigHolder.recipes.hardWoodRecipes) {
                if (!entry.slab.func_190926_b()) {
                    if (hasBoatRecipe) {
                        ModHandler.removeRecipeByName(new ResourceLocation(entry.modid, entry.boatRecipeName));
                    }
                    ModHandler.addShapedRecipe(hasBoatRecipe ? entry.boatRecipeName : name + "_boat", entry.boat.func_77946_l(), "PHP", "PkP", "SSS", Character.valueOf('P'), entry.planks.func_77946_l(), Character.valueOf('S'), entry.slab.func_77946_l(), Character.valueOf('H'), new ItemStack(Items.field_151038_n));
                }
            } else if (!hasBoatRecipe) {
                ModHandler.addShapedRecipe(name + "_boat", entry.boat.func_77946_l(), "P P", "PPP", Character.valueOf('P'), entry.planks.func_77946_l());
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder().inputs(GTUtility.copy(5, entry.planks))).outputs(entry.boat.func_77946_l())).circuitMeta(15)).duration(100)).EUt(4L)).buildAndRegister();
        }
    }

    private static void registerGTWoodRecipes() {
        ModHandler.addShapedRecipe("treated_wood_planks", MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK, 8), "PPP", "PBP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('B'), FluidUtil.getFilledBucket((FluidStack)Materials.Creosote.getFluid(1000)));
        ModHandler.addShapedRecipe("treated_wood_stick", OreDictUnifier.get(OrePrefix.stick, Materials.TreatedWood, ConfigHolder.recipes.nerfWoodCrafting ? 2 : 4), "L", "L", Character.valueOf('L'), MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK));
        if (ConfigHolder.recipes.nerfWoodCrafting) {
            ModHandler.addShapedRecipe("treated_wood_stick_saw", OreDictUnifier.get(OrePrefix.stick, Materials.TreatedWood, 4), "s", "L", "L", Character.valueOf('L'), MetaBlocks.PLANKS.getItemVariant(BlockGregPlanks.BlockType.TREATED_PLANK));
        }
    }

    private static void registerPyrolyseOvenRecipes() {
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(4)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.CharcoalByproducts.getFluid(4000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(9)).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(10)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodTar.getFluid(1500))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(5)).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(6)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodGas.getFluid(1500))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(7)).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.WoodVinegar.getFluid(3000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1)).input(OrePrefix.log, Materials.Wood, 16)).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.Creosote.getFluid(4000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(3)).input(OrePrefix.log, Materials.Wood, 16)).output(OrePrefix.dust, Materials.Ash, 4)).fluidOutputs(Materials.OilHeavy.getFluid(200))).duration(320)).EUt(192L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1)).input(OrePrefix.gem, Materials.Coal, 16)).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.Creosote.getFluid(8000))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2)).input(OrePrefix.gem, Materials.Coal, 16)).fluidInputs(Materials.Nitrogen.getFluid(1000))).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.Creosote.getFluid(8000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1)).input(OrePrefix.block, Materials.Coal, 8)).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.Creosote.getFluid(32000))).duration(2560)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2)).input(OrePrefix.block, Materials.Coal, 8)).fluidInputs(Materials.Nitrogen.getFluid(1000))).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.Creosote.getFluid(32000))).duration(1280)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().EUt(10L)).duration(200)).input(MetaItems.BIO_CHAFF)).circuitMeta(2)).fluidInputs(Materials.Water.getFluid(1500))).fluidOutputs(Materials.FermentedBiomass.getFluid(1500))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().EUt(10L)).duration(900)).input(MetaItems.BIO_CHAFF, 4)).circuitMeta(1)).fluidInputs(Materials.Water.getFluid(4000))).fluidOutputs(Materials.Biomass.getFluid(5000))).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(1)).input(OrePrefix.dust, Materials.Sugar, 23)).output(OrePrefix.dust, Materials.Charcoal, 12)).fluidOutputs(Materials.Water.getFluid(1500))).duration(320)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(2)).input(OrePrefix.dust, Materials.Sugar, 23)).fluidInputs(Materials.Nitrogen.getFluid(500))).output(OrePrefix.dust, Materials.Charcoal, 12)).fluidOutputs(Materials.Water.getFluid(1500))).duration(160)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(20)).input(OrePrefix.log, Materials.Wood, 16)).fluidInputs(Materials.Steam.getFluid(1000))).outputs(new ItemStack(Items.field_151044_h, 20, 1))).fluidOutputs(Materials.CoalGas.getFluid(2000))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(22)).input(OrePrefix.gem, Materials.Coal, 16)).fluidInputs(Materials.Steam.getFluid(1000))).output(OrePrefix.gem, Materials.Coke, 16)).fluidOutputs(Materials.CoalGas.getFluid(4000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(22)).input(OrePrefix.block, Materials.Coal, 8)).fluidInputs(Materials.Steam.getFluid(4000))).output(OrePrefix.block, Materials.Coke, 8)).fluidOutputs(Materials.CoalGas.getFluid(16000))).duration(1280)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8)).inputs(new ItemStack(Items.field_151044_h, 32, 1))).chancedOutput(OrePrefix.dust, Materials.Ash, 5000, 0)).fluidOutputs(Materials.CoalTar.getFluid(1000))).duration(640)).EUt(64L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8)).inputs(new ItemStack(Items.field_151044_h, 12))).chancedOutput(OrePrefix.dust, Materials.DarkAsh, 5000, 0)).fluidOutputs(Materials.CoalTar.getFluid(3000))).duration(320)).EUt(96L)).buildAndRegister();
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PYROLYSE_RECIPES.recipeBuilder().circuitMeta(8)).input(OrePrefix.gem, Materials.Coke, 8)).chancedOutput(OrePrefix.dust, Materials.Ash, 7500, 0)).fluidOutputs(Materials.CoalTar.getFluid(4000))).duration(320)).EUt(96L)).buildAndRegister();
    }
}

