/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SteamBoilerInfoProvider
implements IProbeInfoProvider {
    public String getID() {
        return "gregtech:steam_boiler_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
        SteamBoiler boiler;
        int steamOutput;
        IGregTechTileEntity igtte;
        MetaTileEntity mte;
        TileEntity te;
        if (state.func_177230_c().hasTileEntity(state) && (te = world.func_175625_s(data.getPos())) instanceof IGregTechTileEntity && (mte = (igtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof SteamBoiler && ((steamOutput = (boiler = (SteamBoiler)mte).getTotalSteamOutput()) > 0 || boiler.isBurning())) {
            if (steamOutput > 0 && boiler.hasWater()) {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_production*} " + TextFormatting.AQUA + TextFormattingUtil.formatNumbers(steamOutput / 10) + TextStyleClass.INFO + " L/t {*" + Materials.Steam.getUnlocalizedName() + "*}");
            }
            if (!boiler.isBurning()) {
                probeInfo.text(TextStyleClass.INFO.toString() + TextFormatting.RED + "{*gregtech.top.steam_cooling_down*}");
            }
            if (steamOutput <= 0 && boiler.getCurrentTemperature() > 0) {
                probeInfo.text(TextStyleClass.INFO.toString() + TextFormatting.RED + "{*gregtech.top.steam_heating_up*} " + TextFormattingUtil.formatNumbers(boiler.getCurrentTemperature()) + "%");
            }
            if (!boiler.hasWater()) {
                probeInfo.text(TextStyleClass.WARNING + "{*gregtech.top.steam_no_water*}");
            }
        }
    }
}

