/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.RecipeMapSteamMultiblockController;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class RecipeLogicInfoProvider
extends CapabilityInfoProvider<AbstractRecipeLogic> {
    public String getID() {
        return "gregtech:recipe_logic_provider";
    }

    @Override
    @NotNull
    protected Capability<AbstractRecipeLogic> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC;
    }

    @Override
    protected void addProbeInfo(@NotNull AbstractRecipeLogic capability, @NotNull IProbeInfo probeInfo, @NotNull EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        if (capability.isWorking()) {
            IGregTechTileEntity gtTileEntity;
            MetaTileEntity mte;
            if (capability instanceof PrimitiveRecipeLogic) {
                return;
            }
            long eut = capability.getInfoProviderEUt();
            String text = null;
            if (tileEntity instanceof IGregTechTileEntity && ((mte = (gtTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof SteamMetaTileEntity || mte instanceof MetaTileEntityLargeBoiler || mte instanceof RecipeMapSteamMultiblockController)) {
                text = TextFormatting.AQUA + TextFormattingUtil.formatNumbers(eut) + TextStyleClass.INFO + " L/t {*" + Materials.Steam.getUnlocalizedName() + "*}";
            }
            if (text == null) {
                text = TextFormatting.RED + TextFormattingUtil.formatNumbers(eut) + TextStyleClass.INFO + " EU/t" + TextFormatting.GREEN + " (" + GTValues.VOCNF[GTUtility.getOCTierByVoltage(eut)] + TextFormatting.GREEN + ")";
            }
            if (eut == 0L) {
                return;
            }
            if (capability.consumesEnergy()) {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_consumption*} " + text);
            } else {
                probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_production*} " + text);
            }
        }
    }
}

