/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class QuantumStorageProvider
implements IProbeInfoProvider {
    public String getID() {
        return ":quantum_storage_provider";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tileEntity;
        if (blockState.func_177230_c().hasTileEntity(blockState) && (tileEntity = world.func_175625_s(data.getPos())) instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
            MetaTileEntity metaTileEntity = gtte.getMetaTileEntity();
            if (metaTileEntity instanceof IQuantumController) {
                IQuantumController controller = (IQuantumController)((Object)metaTileEntity);
                String eutText = this.configureEnergyUsage(controller.getEnergyUsage() / 10L);
                if (controller.getCount(IQuantumStorage.Type.ENERGY) == 0) {
                    probeInfo.text("{*gregtech.top.quantum_controller.no_hatches*}");
                    probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_required*} " + eutText);
                } else if (!controller.isPowered()) {
                    probeInfo.text("{*gregtech.top.quantum_controller.no_power*}");
                    probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_required*} " + eutText);
                } else {
                    probeInfo.text(TextStyleClass.INFO + "{*gregtech.top.energy_consumption*} " + eutText);
                }
            } else {
                IQuantumStorage storage;
                metaTileEntity = gtte.getMetaTileEntity();
                if (metaTileEntity instanceof IQuantumStorage && ((storage = (IQuantumStorage)((Object)metaTileEntity)).getType() == IQuantumStorage.Type.ITEM || storage.getType() == IQuantumStorage.Type.FLUID)) {
                    probeInfo.text(QuantumStorageProvider.getConnectionStatus(storage));
                }
            }
        }
    }

    @NotNull
    private static String getConnectionStatus(IQuantumStorage<?> storage) {
        IQuantumController qcontroller = storage.getQuantumController();
        String status = "gregtech.top.quantum_status.disconnected";
        if (qcontroller != null) {
            status = qcontroller.isPowered() ? "gregtech.top.quantum_status.powered" : "gregtech.top.quantum_status.connected";
        }
        return TextStyleClass.INFO + "{*gregtech.top.quantum_status.label*} {*" + status + "*}";
    }

    public String configureEnergyUsage(long EUs) {
        return TextFormatting.RED.toString() + EUs + TextStyleClass.INFO + " EU/t" + TextFormatting.GREEN + " (" + GTValues.VNF[GTUtility.getTierByVoltage(EUs)] + TextFormatting.GREEN + ")";
    }
}

