/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.ILaserContainer;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class LaserContainerInfoProvider
extends CapabilityInfoProvider<ILaserContainer> {
    @Override
    @NotNull
    protected Capability<ILaserContainer> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_LASER;
    }

    @Override
    protected boolean allowDisplaying(@NotNull ILaserContainer capability) {
        return !capability.isOneProbeHidden();
    }

    @Override
    protected void addProbeInfo(ILaserContainer capability, IProbeInfo probeInfo, EntityPlayer player, TileEntity tileEntity, IProbeHitData data) {
        long maxStorage = capability.getEnergyCapacity();
        long stored = capability.getEnergyStored();
        if (maxStorage == 0L) {
            return;
        }
        probeInfo.progress(stored, maxStorage, probeInfo.defaultProgressStyle().numberFormat(player.func_70093_af() || stored < 10000L ? NumberFormat.FULL : NumberFormat.COMPACT).suffix(" / " + (player.func_70093_af() || maxStorage < 10000L ? maxStorage + " EU" : ElementProgress.format((long)maxStorage, (NumberFormat)NumberFormat.COMPACT, (String)"EU"))).filledColor(-1120768).alternateFilledColor(-1120768).borderColor(-11184811));
    }

    public String getID() {
        return "gregtech:laser_container_provider";
    }
}

