/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.ILaserContainer;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ElectricContainerInfoProvider
extends CapabilityInfoProvider<IEnergyContainer> {
    public String getID() {
        return "gregtech:energy_container_provider";
    }

    @Override
    @NotNull
    protected Capability<IEnergyContainer> getCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Override
    protected boolean allowDisplaying(@NotNull IEnergyContainer capability) {
        return !capability.isOneProbeHidden() && !(capability instanceof ILaserContainer);
    }

    @Override
    protected void addProbeInfo(@NotNull IEnergyContainer capability, @NotNull IProbeInfo probeInfo, EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        long maxStorage = capability.getEnergyCapacity();
        long stored = capability.getEnergyStored();
        if (maxStorage == 0L) {
            return;
        }
        probeInfo.progress(capability.getEnergyStored(), maxStorage, probeInfo.defaultProgressStyle().numberFormat(player.func_70093_af() || stored < 10000L ? NumberFormat.COMMAS : NumberFormat.COMPACT).suffix(" / " + (player.func_70093_af() || maxStorage < 10000L ? ElementProgress.format((long)maxStorage, (NumberFormat)NumberFormat.COMMAS, (String)" EU") : ElementProgress.format((long)maxStorage, (NumberFormat)NumberFormat.COMPACT, (String)"EU"))).filledColor(-1120768).alternateFilledColor(-1120768).borderColor(-11184811));
    }
}

