/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverHolder;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.covers.CoverConveyor;
import gregtech.common.covers.CoverFluidFilter;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.CoverFluidVoiding;
import gregtech.common.covers.CoverFluidVoidingAdvanced;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverItemVoiding;
import gregtech.common.covers.CoverItemVoidingAdvanced;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.CoverRoboticArm;
import gregtech.common.covers.IIOMode;
import gregtech.common.covers.TransferMode;
import gregtech.common.covers.VoidingMode;
import gregtech.common.covers.ender.CoverEnderFluidLink;
import gregtech.common.covers.filter.BaseFilter;
import gregtech.common.covers.filter.FluidFilterContainer;
import gregtech.common.covers.filter.ItemFilterContainer;
import gregtech.common.covers.filter.OreDictionaryItemFilter;
import gregtech.common.covers.filter.SmartItemFilter;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverInfoProvider
extends CapabilityInfoProvider<CoverHolder> {
    @Override
    @NotNull
    protected Capability<CoverHolder> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_COVER_HOLDER;
    }

    public String getID() {
        return "gregtech:coverable_provider";
    }

    @Override
    protected void addProbeInfo(@NotNull CoverHolder capability, @NotNull IProbeInfo probeInfo, @NotNull EntityPlayer player, @NotNull TileEntity tileEntity, @NotNull IProbeHitData data) {
        Cover cover = capability.getCoverAtSide(data.getSideHit());
        if (cover instanceof CoverConveyor) {
            CoverConveyor conveyor = (CoverConveyor)cover;
            CoverInfoProvider.conveyorInfo(probeInfo, conveyor);
        } else if (cover instanceof CoverPump) {
            CoverPump coverPump = (CoverPump)cover;
            CoverInfoProvider.pumpInfo(probeInfo, coverPump);
        } else if (cover instanceof CoverItemFilter) {
            CoverItemFilter itemFilter = (CoverItemFilter)cover;
            CoverInfoProvider.itemFilterInfo(probeInfo, itemFilter);
        } else if (cover instanceof CoverFluidFilter) {
            CoverFluidFilter fluidFilter = (CoverFluidFilter)cover;
            CoverInfoProvider.fluidFilterInfo(probeInfo, fluidFilter);
        } else if (cover instanceof CoverEnderFluidLink) {
            CoverEnderFluidLink enderFluidLink = (CoverEnderFluidLink)cover;
            CoverInfoProvider.enderFluidLinkInfo(probeInfo, enderFluidLink);
        }
    }

    private static void conveyorInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverConveyor conveyor) {
        CoverRoboticArm arm;
        String rateUnit = CoverInfoProvider.lang("cover.conveyor.transfer_rate");
        if (conveyor instanceof CoverItemVoiding) {
            CoverInfoProvider.itemVoidingInfo(probeInfo, (CoverItemVoiding)conveyor);
        } else if (!(conveyor instanceof CoverRoboticArm) || (arm = (CoverRoboticArm)conveyor).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverInfoProvider.transferRateText(probeInfo, conveyor.getConveyorMode(), " " + rateUnit, conveyor.getTransferRate());
        }
        ItemFilterContainer filter = conveyor.getItemFilterContainer();
        if (conveyor instanceof CoverRoboticArm) {
            CoverRoboticArm roboticArm = (CoverRoboticArm)conveyor;
            if (roboticArm.getTransferMode() != TransferMode.TRANSFER_ANY) {
                rateUnit = CoverInfoProvider.lang("cover.robotic_arm.exact");
            }
            CoverInfoProvider.transferModeText(probeInfo, roboticArm.getTransferMode(), rateUnit, filter.getTransferSize(), filter.hasFilter());
        }
        CoverInfoProvider.itemFilterText(probeInfo, filter.getFilter());
    }

    private static void itemVoidingInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverItemVoiding voiding) {
        String unit = CoverInfoProvider.lang("gregtech.top.unit.items");
        ItemFilterContainer container = voiding.getItemFilterContainer();
        if (voiding instanceof CoverItemVoidingAdvanced) {
            CoverItemVoidingAdvanced advanced = (CoverItemVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverInfoProvider.voidingText(probeInfo, mode, unit, container.getTransferSize(), container.hasFilter() && !container.isBlacklistFilter());
        }
    }

    private static void pumpInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverPump pump) {
        CoverFluidRegulator regulator;
        String rateUnit = CoverInfoProvider.lang(pump.getBucketMode() == CoverPump.BucketMode.BUCKET ? "cover.bucket.mode.bucket_rate" : "cover.bucket.mode.milli_bucket_rate");
        if (pump instanceof CoverFluidVoiding) {
            CoverInfoProvider.fluidVoidingInfo(probeInfo, (CoverFluidVoiding)pump);
        } else if (!(pump instanceof CoverFluidRegulator) || (regulator = (CoverFluidRegulator)pump).getTransferMode() == TransferMode.TRANSFER_ANY) {
            CoverInfoProvider.transferRateText(probeInfo, pump.getPumpMode(), " " + rateUnit, pump.getBucketMode() == CoverPump.BucketMode.BUCKET ? pump.getTransferRate() / 1000 : pump.getTransferRate());
        }
        FluidFilterContainer filter = pump.getFluidFilterContainer();
        if (pump instanceof CoverFluidRegulator) {
            CoverFluidRegulator regulator2 = (CoverFluidRegulator)pump;
            if (regulator2.getTransferMode() != TransferMode.TRANSFER_ANY) {
                rateUnit = CoverInfoProvider.lang(regulator2.getBucketMode() == CoverPump.BucketMode.BUCKET ? "gregtech.top.unit.fluid_buckets" : "gregtech.top.unit.fluid_milibuckets");
            }
            CoverInfoProvider.transferModeText(probeInfo, regulator2.getTransferMode(), rateUnit, regulator2.getFluidFilterContainer().getTransferSize(), filter.hasFilter() && !filter.isBlacklistFilter());
        }
        CoverInfoProvider.fluidFilterText(probeInfo, filter.getFilter());
    }

    private static void fluidVoidingInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverFluidVoiding voiding) {
        String unit = CoverInfoProvider.lang(voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? "gregtech.top.unit.fluid_buckets" : "gregtech.top.unit.fluid_milibuckets");
        FluidFilterContainer container = voiding.getFluidFilterContainer();
        if (voiding instanceof CoverFluidVoidingAdvanced) {
            CoverFluidVoidingAdvanced advanced = (CoverFluidVoidingAdvanced)voiding;
            VoidingMode mode = advanced.getVoidingMode();
            CoverInfoProvider.voidingText(probeInfo, mode, unit, voiding.getBucketMode() == CoverPump.BucketMode.BUCKET ? advanced.getTransferAmount() / 1000 : advanced.getTransferAmount(), container.hasFilter() && !container.isBlacklistFilter());
        }
    }

    private static void itemFilterInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverItemFilter itemFilter) {
        CoverInfoProvider.filterModeText(probeInfo, itemFilter.getFilterMode());
        CoverInfoProvider.itemFilterText(probeInfo, itemFilter.getFilter());
    }

    private static void fluidFilterInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverFluidFilter fluidFilter) {
        CoverInfoProvider.filterModeText(probeInfo, fluidFilter.getFilterMode());
        CoverInfoProvider.fluidFilterText(probeInfo, fluidFilter.getFilter());
    }

    private static void enderFluidLinkInfo(@NotNull IProbeInfo probeInfo, @NotNull CoverEnderFluidLink enderFluidLink) {
        CoverInfoProvider.transferRateText(probeInfo, enderFluidLink.getPumpMode(), " " + CoverInfoProvider.lang("cover.ender_fluid_link.transfer_unit"), enderFluidLink.isIoEnabled() ? 8000 : 0);
        CoverInfoProvider.fluidFilterText(probeInfo, enderFluidLink.getFluidFilterContainer().getFilter());
        if (!enderFluidLink.getColorStr().isEmpty()) {
            probeInfo.text(TextStyleClass.INFO + CoverInfoProvider.lang("gregtech.top.link_cover.color") + " " + enderFluidLink.getColorStr());
        }
    }

    private static void transferRateText(@NotNull IProbeInfo probeInfo, @NotNull IIOMode mode, @NotNull String rateUnit, int rate) {
        String modeText = mode.isImport() ? CoverInfoProvider.lang("gregtech.top.mode.import") : CoverInfoProvider.lang("gregtech.top.mode.export");
        modeText = modeText + " ";
        probeInfo.text(TextStyleClass.OK + modeText + TextStyleClass.LABEL + TextFormattingUtil.formatNumbers(rate) + rateUnit);
    }

    private static void transferModeText(@NotNull IProbeInfo probeInfo, @NotNull TransferMode mode, @NotNull String rateUnit, int rate, boolean hasFilter) {
        String text = TextStyleClass.OK + CoverInfoProvider.lang(mode.func_176610_l());
        if (!hasFilter && mode != TransferMode.TRANSFER_ANY) {
            text = text + TextStyleClass.LABEL + " " + TextFormattingUtil.formatNumbers(rate) + " " + rateUnit;
        }
        probeInfo.text(text);
    }

    private static void voidingText(@NotNull IProbeInfo probeInfo, @NotNull VoidingMode mode, @NotNull String unit, int amount, boolean hasFilter) {
        String text = TextFormatting.RED + CoverInfoProvider.lang(mode.func_176610_l());
        if (mode != VoidingMode.VOID_ANY && !hasFilter) {
            text = text + " " + TextFormattingUtil.formatNumbers(amount) + " " + unit;
        }
        probeInfo.text(text);
    }

    private static void filterModeText(@NotNull IProbeInfo probeInfo, @NotNull IStringSerializable mode) {
        probeInfo.text(TextStyleClass.WARNING + CoverInfoProvider.lang(mode.func_176610_l()));
    }

    private static void itemFilterText(@NotNull IProbeInfo probeInfo, @Nullable BaseFilter filter) {
        String label = TextStyleClass.INFO + CoverInfoProvider.lang("gregtech.top.filter.label");
        if (filter instanceof OreDictionaryItemFilter) {
            String expression = ((OreDictionaryItemFilter)filter).getExpression();
            if (!expression.isEmpty()) {
                probeInfo.text(label + expression);
            }
        } else if (filter instanceof SmartItemFilter) {
            SmartItemFilter smartItemFilter = (SmartItemFilter)filter;
            probeInfo.text(label + CoverInfoProvider.lang(smartItemFilter.getFilteringMode().func_176610_l()));
        }
    }

    private static void fluidFilterText(@NotNull IProbeInfo probeInfo, @Nullable BaseFilter filter) {
    }

    private static String lang(String lang) {
        return "{*" + lang + "*}";
    }
}

