/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.electric.MetaTileEntityBatteryBuffer;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class BatteryBufferInfoProvider
extends CapabilityInfoProvider<IEnergyContainer> {
    public String getID() {
        return "gregtech:battery_buffer_provider";
    }

    @Override
    @NotNull
    protected Capability<IEnergyContainer> getCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Override
    protected void addProbeInfo(IEnergyContainer capability, IProbeInfo probeInfo, EntityPlayer player, TileEntity tileEntity, IProbeHitData data) {
        IGregTechTileEntity iGregTechTileEntity;
        MetaTileEntity metaTileEntity;
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = (iGregTechTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MetaTileEntityBatteryBuffer) {
            long averageIn = capability.getInputPerSec() / 20L;
            TextComponentTranslation averageInFormatted = TextComponentUtil.translationWithColor(TextFormatting.GREEN, "gregtech.battery_buffer.average_input.top", TextComponentUtil.stringWithColor(TextFormatting.WHITE, player.func_70093_af() || averageIn < 10000L ? TextFormattingUtil.formatNumbers(averageIn) + " EU/t" : ElementProgress.format((long)averageIn, (NumberFormat)NumberFormat.COMPACT, (String)"EU/t")));
            probeInfo.text(averageInFormatted.func_150254_d());
            long averageOut = capability.getOutputPerSec() / 20L;
            TextComponentTranslation averageOutFormatted = TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.battery_buffer.average_output.top", TextComponentUtil.stringWithColor(TextFormatting.WHITE, player.func_70093_af() || averageOut < 10000L ? TextFormattingUtil.formatNumbers(averageOut) + " EU/t" : ElementProgress.format((long)averageOut, (NumberFormat)NumberFormat.COMPACT, (String)"EU/t")));
            probeInfo.text(averageOutFormatted.func_150254_d());
        }
    }
}

