/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityActiveTransformer;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ActiveTransformerInfoProvider
extends CapabilityInfoProvider<IMultiblockController> {
    public String getID() {
        return "gregtech:active_transformer_info_provider";
    }

    @Override
    protected boolean allowDisplaying(@NotNull IMultiblockController capability) {
        MetaTileEntityActiveTransformer activeTransformer;
        return capability instanceof MetaTileEntityActiveTransformer && (activeTransformer = (MetaTileEntityActiveTransformer)capability).isActive();
    }

    @Override
    @NotNull
    protected Capability<IMultiblockController> getCapability() {
        return GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER;
    }

    @Override
    protected void addProbeInfo(IMultiblockController capability, IProbeInfo probeInfo, EntityPlayer player, TileEntity tileEntity, IProbeHitData data) {
        long averageIO = ((MetaTileEntityActiveTransformer)capability).getAverageIOLastSec();
        TextComponentTranslation text = TextComponentUtil.translationWithColor(TextFormatting.AQUA, "gregtech.multiblock.active_transformer.average_io", TextComponentUtil.stringWithColor(TextFormatting.WHITE, player.func_70093_af() || averageIO < 10000L ? TextFormattingUtil.formatNumbers(averageIO) + " EU/t" : ElementProgress.format((long)averageIO, (NumberFormat)NumberFormat.COMPACT, (String)"EU/t")));
        probeInfo.text(text.func_150254_d());
    }
}

