/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.values;

import gregtech.api.cover.Cover;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.ender.CoverEnderFluidLink;
import gregtech.integration.opencomputers.InputValidator;
import gregtech.integration.opencomputers.values.ValueCoverBehavior;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.EnumFacing;

public class ValueCoverEnderFluidLink
extends ValueCoverBehavior {
    public ValueCoverEnderFluidLink(CoverEnderFluidLink coverBehavior, EnumFacing side) {
        super(coverBehavior, side, "gt_coverEnderFluidLink");
    }

    @Override
    protected CoverEnderFluidLink getCover() {
        Cover cover = super.getCover();
        return cover instanceof CoverEnderFluidLink ? (CoverEnderFluidLink)cover : null;
    }

    @Callback(doc="function(mode:string) --  Sets the color channel. Must be RGBA hexcode string (like 0xAF5614BB).")
    public Object[] setColorChannel(Context context, Arguments args) {
        CoverEnderFluidLink cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        String colorString = InputValidator.getColorString(args, 0);
        cover.updateColor(colorString);
        return new Object[0];
    }

    @Callback(doc="function():string --  Gets the color channel.")
    public Object[] getColorChannel(Context context, Arguments args) {
        CoverEnderFluidLink cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getColorStr()};
    }

    @Callback(doc="function(mode:number) --  Sets pump mode. (0:IMPORT, 1:EXPORT)")
    public Object[] setPumpMode(Context context, Arguments args) {
        CoverEnderFluidLink cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        CoverPump.PumpMode mode = (CoverPump.PumpMode)InputValidator.getEnumArrayIndex((Arguments)args, (int)0, (Enum[])CoverPump.PumpMode.values());
        cover.setPumpMode(mode);
        return new Object[0];
    }

    @Callback(doc="function():number --  Gets pump mode. (0:IMPORT, 1:EXPORT)")
    public Object[] getPumpMode(Context context, Arguments args) {
        CoverEnderFluidLink cover = this.getCover();
        if (cover == null) {
            return this.NULL_COVER;
        }
        return new Object[]{cover.getPumpMode().ordinal()};
    }
}

