/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.opencomputers.drivers;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.chance.output.impl.ChancedFluidOutput;
import gregtech.api.recipes.chance.output.impl.ChancedItemOutput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.integration.opencomputers.drivers.EnvironmentMetaTileEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class DriverAbstractRecipeLogic
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return AbstractRecipeLogic.class;
    }

    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity) {
            return tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, side);
        }
        return false;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        IWorkable capability;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IGregTechTileEntity && (capability = (IWorkable)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, side)) instanceof AbstractRecipeLogic) {
            return new EnvironmentAbstractRecipeLogic((IGregTechTileEntity)tileEntity, (AbstractRecipeLogic)capability);
        }
        return null;
    }

    public static final class EnvironmentAbstractRecipeLogic
    extends EnvironmentMetaTileEntity<AbstractRecipeLogic> {
        public EnvironmentAbstractRecipeLogic(IGregTechTileEntity holder, AbstractRecipeLogic capability) {
            super(holder, capability, "gt_recipeLogic");
        }

        @Callback(doc="function():table -- Returns previous recipe.")
        public Object[] getCurrentRecipe(Context context, Arguments args) {
            Recipe previousRecipe = ((AbstractRecipeLogic)this.tileEntity).getPreviousRecipe();
            if (previousRecipe != null && ((AbstractRecipeLogic)this.tileEntity).isActive()) {
                Object2ObjectOpenHashMap recipe = new Object2ObjectOpenHashMap();
                recipe.put("duration", previousRecipe.getDuration());
                recipe.put("EUt", previousRecipe.getEUt());
                ArrayList itemInput = new ArrayList();
                List<GTRecipeInput> inputs = previousRecipe.getInputs();
                inputs.forEach(iR -> {
                    for (ItemStack itemStack : iR.getInputStacks()) {
                        Object2ObjectOpenHashMap input = new Object2ObjectOpenHashMap();
                        input.put("count", iR.getAmount());
                        input.put("name", itemStack.func_82833_r());
                        itemInput.add(input);
                    }
                });
                if (!itemInput.isEmpty()) {
                    recipe.put("itemInputs", itemInput);
                }
                ArrayList fluidInput = new ArrayList();
                List<GTRecipeInput> fluidInputs = previousRecipe.getFluidInputs();
                fluidInputs.forEach(iR -> {
                    Object2ObjectOpenHashMap input = new Object2ObjectOpenHashMap();
                    input.put("amount", iR.getAmount());
                    input.put("name", iR.getInputFluidStack().getFluid().getName());
                    fluidInput.add(input);
                });
                if (!fluidInput.isEmpty()) {
                    recipe.put("fluidInputs", fluidInput);
                }
                ArrayList itemOutput = new ArrayList();
                List<ItemStack> outputs = previousRecipe.getOutputs();
                outputs.forEach(iR -> {
                    Object2ObjectOpenHashMap output = new Object2ObjectOpenHashMap();
                    output.put("count", iR.func_190916_E());
                    output.put("name", iR.func_82833_r());
                    itemOutput.add(output);
                });
                if (!itemOutput.isEmpty()) {
                    recipe.put("itemOutputs", itemOutput);
                }
                ArrayList chancedItemOutput = new ArrayList();
                List<ChancedItemOutput> chancedOutputs = previousRecipe.getChancedOutputs().getChancedEntries();
                chancedOutputs.forEach(iR -> {
                    Object2ObjectOpenHashMap output = new Object2ObjectOpenHashMap();
                    output.put("chance", iR.getChance());
                    output.put("boostPerTier", iR.getChanceBoost());
                    output.put("count", ((ItemStack)iR.getIngredient()).func_190916_E());
                    output.put("name", ((ItemStack)iR.getIngredient()).func_82833_r());
                    chancedItemOutput.add(output);
                });
                if (!chancedItemOutput.isEmpty()) {
                    recipe.put("chancedItemOutput", chancedItemOutput);
                }
                ArrayList fluidOutput = new ArrayList();
                List<FluidStack> fluidOutputs = previousRecipe.getFluidOutputs();
                fluidOutputs.forEach(iR -> {
                    Object2ObjectOpenHashMap output = new Object2ObjectOpenHashMap();
                    output.put("amount", iR.amount);
                    output.put("name", iR.getFluid().getName());
                    fluidOutput.add(output);
                });
                if (!fluidOutput.isEmpty()) {
                    recipe.put("fluidOutputs", fluidOutput);
                }
                ArrayList chancedFluidOutput = new ArrayList();
                List<ChancedFluidOutput> chancedFluidOutputs = previousRecipe.getChancedFluidOutputs().getChancedEntries();
                chancedFluidOutputs.forEach(iR -> {
                    Object2ObjectOpenHashMap output = new Object2ObjectOpenHashMap();
                    output.put("chance", iR.getChance());
                    output.put("boostPerTier", iR.getChanceBoost());
                    output.put("count", ((FluidStack)iR.getIngredient()).amount);
                    output.put("name", ((FluidStack)iR.getIngredient()).getFluid().getName());
                    chancedFluidOutput.add(output);
                });
                if (!chancedFluidOutput.isEmpty()) {
                    recipe.put("chancedFluidOutput", chancedFluidOutput);
                }
                return new Object[]{recipe};
            }
            return new Object[]{null};
        }
    }
}

