/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils.render;

import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.recipes.chance.output.ChancedOutputLogic;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackTextRenderer
extends ItemStackRenderer {
    private final int chanceBase;
    private final int chanceBoost;
    private final ChancedOutputLogic chanceLogic;
    private final boolean notConsumed;

    public ItemStackTextRenderer(BoostableChanceEntry<ItemStack> chance, ChancedOutputLogic chanceLogic) {
        if (chance != null && chanceLogic != null) {
            this.chanceBase = chance.getChance();
            this.chanceBoost = chance.getChanceBoost();
            this.chanceLogic = chanceLogic;
        } else {
            this.chanceBase = -1;
            this.chanceBoost = -1;
            this.chanceLogic = null;
        }
        this.notConsumed = false;
    }

    public ItemStackTextRenderer(int chanceBase, int chanceBoost) {
        this.chanceBase = chanceBase;
        this.chanceBoost = chanceBoost;
        this.chanceLogic = null;
        this.notConsumed = false;
    }

    public ItemStackTextRenderer(boolean notConsumed) {
        this.chanceBase = -1;
        this.chanceBoost = -1;
        this.chanceLogic = null;
        this.notConsumed = notConsumed;
    }

    public void render(@NotNull Minecraft minecraft, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        super.render(minecraft, xPosition, yPosition, ingredient);
        if (this.chanceBase >= 0) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)160.0f);
            String s = this.chanceBase / 100 + "%";
            if (this.chanceLogic != null && this.chanceLogic != ChancedOutputLogic.NONE && this.chanceLogic != ChancedOutputLogic.OR) {
                s = s + "*";
            } else if (this.chanceBoost > 0) {
                s = s + "+";
            }
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_175063_a(s, (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a(s) + 19), (float)((yPosition + 1) * 2), 0xFFFF00);
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
        } else if (this.notConsumed) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)160.0f);
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            fontRenderer.func_175063_a("NC", (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a("NC") + 19), (float)((yPosition + 1) * 2), 0xFFFF00);
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
        }
    }
}

