/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import com.google.common.collect.Lists;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.facade.FacadeHelper;
import gregtech.common.items.MetaItems;
import gregtech.common.items.behaviors.FacadeItem;
import gregtech.integration.jei.recipe.FacadeRecipeWrapper;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class FacadeRegistryPlugin
implements IRecipeRegistryPlugin {
    @NotNull
    public <V> List<String> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getValue() instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.OUTPUT ? MetaItems.COVER_FACADE.isItemEqual(itemStack) : focus.getMode() == IFocus.Mode.INPUT && FacadeHelper.isValidFacade(itemStack)) {
                return Collections.singletonList("minecraft.crafting");
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public <T extends IRecipeWrapper, V> List<T> getRecipeWrappers(IRecipeCategory<T> recipeCategory, @NotNull IFocus<V> focus) {
        if (!"minecraft.crafting".equals(recipeCategory.getUid())) {
            return Collections.emptyList();
        }
        if (focus.getValue() instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.OUTPUT) {
                if (MetaItems.COVER_FACADE.isItemEqual(itemStack)) {
                    return FacadeRegistryPlugin.createFacadeRecipes(itemStack);
                }
            } else if (focus.getMode() == IFocus.Mode.INPUT && FacadeHelper.isValidFacade(itemStack)) {
                ItemStack coverStack = MetaItems.COVER_FACADE.getStackForm();
                FacadeItem.setFacadeStack(coverStack, itemStack);
                return FacadeRegistryPlugin.createFacadeRecipes(coverStack);
            }
        }
        return Collections.emptyList();
    }

    private static List<IRecipeWrapper> createFacadeRecipes(ItemStack itemStack) {
        return Lists.newArrayList((Object[])new IRecipeWrapper[]{FacadeRegistryPlugin.createFacadeRecipe(itemStack, Materials.Iron, 4)});
    }

    private static IRecipeWrapper createFacadeRecipe(ItemStack itemStack, Material material, int facadeAmount) {
        ItemStack itemStackCopy = itemStack.func_77946_l();
        itemStackCopy.func_190920_e(facadeAmount);
        return new FacadeRecipeWrapper(GTUtility.gregtechId("facade_" + material), OreDictUnifier.get(OrePrefix.plate, material), itemStackCopy);
    }

    @NotNull
    public <T extends IRecipeWrapper> List<T> getRecipeWrappers(@NotNull IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }
}

