/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.multiblock;

import gregtech.api.gui.GuiTextures;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.integration.jei.multiblock.MultiblockInfoRecipeWrapper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.NotNull;

public class MultiblockInfoCategory
implements IRecipeCategory<MultiblockInfoRecipeWrapper> {
    public static final String UID = String.format("%s.multiblock_info", "gregtech");
    private final IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper guiHelper;
    public static final List<MultiblockControllerBase> REGISTER = new LinkedList<MultiblockControllerBase>();

    public MultiblockInfoCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.background = this.guiHelper.createBlankDrawable(176, 166);
        this.icon = this.guiHelper.drawableBuilder(GuiTextures.MULTIBLOCK_CATEGORY.imageLocation, 0, 0, 16, 16).setTextureSize(16, 16).build();
    }

    public static void registerMultiblock(MultiblockControllerBase controllerBase) {
        REGISTER.add(controllerBase);
    }

    public static void registerRecipes(IModRegistry registry) {
        registry.addRecipes((Collection)REGISTER.stream().map(MultiblockInfoRecipeWrapper::new).collect(Collectors.toList()), UID);
    }

    @NotNull
    public String getUid() {
        return UID;
    }

    @NotNull
    public String getTitle() {
        return I18n.func_135052_a((String)"gregtech.multiblock.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getModName() {
        return "gregtech";
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayout recipeLayout, MultiblockInfoRecipeWrapper recipeWrapper, @NotNull IIngredients ingredients) {
        recipeWrapper.setRecipeLayout((RecipeLayout)recipeLayout, this.guiHelper);
    }
}

