/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.PrimitiveRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.RecipeMapSteamMultiblockController;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.multi.MetaTileEntityLargeBoiler;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class RecipeLogicDataProvider
extends CapabilityDataProvider<AbstractRecipeLogic> {
    public static final RecipeLogicDataProvider INSTANCE = new RecipeLogicDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.recipe_logic");
    }

    @Override
    @NotNull
    protected Capability<AbstractRecipeLogic> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC;
    }

    @Override
    protected NBTTagCompound getNBTData(AbstractRecipeLogic capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74757_a("Working", capability.isWorking());
        if (capability.isWorking() && !(capability instanceof PrimitiveRecipeLogic)) {
            subTag.func_74772_a("RecipeEUt", capability.getInfoProviderEUt());
        }
        tag.func_74782_a("gregtech.AbstractRecipeLogic", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag;
        if (!config.getConfig("gregtech.recipe_logic") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.AbstractRecipeLogic") && (tag = accessor.getNBTData().func_74775_l("gregtech.AbstractRecipeLogic")).func_74767_n("Working")) {
            long eut = tag.func_74763_f("RecipeEUt");
            boolean consumer = false;
            String endText = null;
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof IGregTechTileEntity) {
                AbstractRecipeLogic arl;
                IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
                MetaTileEntity mte = gtte.getMetaTileEntity();
                if (mte instanceof SteamMetaTileEntity || mte instanceof MetaTileEntityLargeBoiler || mte instanceof RecipeMapSteamMultiblockController) {
                    endText = ": " + TextFormattingUtil.formatNumbers(eut) + TextFormatting.RESET + " L/t " + I18n.func_135052_a((String)Materials.Steam.getUnlocalizedName(), (Object[])new Object[0]);
                }
                if ((arl = mte.getRecipeLogic()) != null) {
                    consumer = arl.consumesEnergy();
                }
            }
            if (endText == null) {
                endText = ": " + TextFormattingUtil.formatNumbers(eut) + TextFormatting.RESET + " EU/t (" + GTValues.VOCNF[GTUtility.getOCTierByVoltage(eut)] + TextFormatting.RESET + ")";
            }
            if (eut == 0L) {
                return tooltip;
            }
            if (consumer) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_consumption", (Object[])new Object[0]) + endText);
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_production", (Object[])new Object[0]) + endText);
            }
        }
        return tooltip;
    }
}

