/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.GTValues;
import gregtech.api.capability.IQuantumController;
import gregtech.api.capability.IQuantumStorage;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class QuantumStorageProvider
implements IWailaDataProvider {
    public static final QuantumStorageProvider INSTANCE = new QuantumStorageProvider();

    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, IGregTechTileEntity.class);
        registrar.addConfig("GregTech", "gregtech.quantum_storage");
    }

    @NotNull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        IQuantumStorage storage;
        IGregTechTileEntity gtte;
        MetaTileEntity metaTileEntity;
        if (te instanceof IGregTechTileEntity && (metaTileEntity = (gtte = (IGregTechTileEntity)te).getMetaTileEntity()) instanceof IQuantumStorage && ((storage = (IQuantumStorage)((Object)metaTileEntity)).getType() == IQuantumStorage.Type.ITEM || storage.getType() == IQuantumStorage.Type.FLUID)) {
            IQuantumController controller = storage.getQuantumController();
            int status = 0;
            if (controller != null) {
                status = controller.isPowered() ? 1 : 2;
            }
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74768_a("Connection", status);
            tag.func_74782_a("gregtech.IQuantumStorageController", (NBTBase)subTag);
        }
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Object eutText;
        TileEntity tileEntity;
        if (!config.getConfig("gregtech.quantum_storage") || !((tileEntity = accessor.getTileEntity()) instanceof IGregTechTileEntity)) {
            return tooltip;
        }
        IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
        MetaTileEntity metaTileEntity = gtte.getMetaTileEntity();
        if (metaTileEntity instanceof IQuantumController) {
            IQuantumController controller = (IQuantumController)((Object)metaTileEntity);
            eutText = this.configureEnergyUsage(controller.getEnergyUsage() / 10L);
            if (controller.getCount(IQuantumStorage.Type.ENERGY) == 0) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.quantum_controller.no_hatches", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_required", (Object[])new Object[0]) + (String)eutText);
            } else if (!controller.isPowered()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.quantum_controller.no_power", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_required", (Object[])new Object[0]) + (String)eutText);
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.top.energy_consumption", (Object[])new Object[0]) + (String)eutText);
            }
        } else {
            IQuantumStorage storage;
            eutText = gtte.getMetaTileEntity();
            if (eutText instanceof IQuantumStorage && ((storage = (IQuantumStorage)eutText).getType() == IQuantumStorage.Type.ITEM || storage.getType() == IQuantumStorage.Type.FLUID) && accessor.getNBTData().func_74764_b("gregtech.IQuantumStorageController")) {
                String status;
                NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.IQuantumStorageController");
                int connection = tag.func_74762_e("Connection");
                switch (connection) {
                    case 1: {
                        status = I18n.func_135052_a((String)"gregtech.top.quantum_status.powered", (Object[])new Object[0]);
                        break;
                    }
                    case 2: {
                        status = I18n.func_135052_a((String)"gregtech.top.quantum_status.connected", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        status = I18n.func_135052_a((String)"gregtech.top.quantum_status.disconnected", (Object[])new Object[0]);
                    }
                }
                status = I18n.func_135052_a((String)"gregtech.top.quantum_status.label", (Object[])new Object[0]) + status;
                tooltip.add(status);
            }
        }
        return tooltip;
    }

    public String configureEnergyUsage(long EUs) {
        return TextFormatting.RED.toString() + EUs + " EU/t" + TextFormatting.GREEN + " (" + GTValues.VNF[GTUtility.getTierByVoltage(EUs)] + TextFormatting.GREEN + ")";
    }
}

