/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.electric.MetaTileEntityBatteryBuffer;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class BatteryBufferDataProvider
extends CapabilityDataProvider<IEnergyContainer> {
    public static final BatteryBufferDataProvider INSTANCE = new BatteryBufferDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.battery-buffer");
    }

    @Override
    @NotNull
    protected Capability<IEnergyContainer> getCapability() {
        return GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER;
    }

    @Override
    protected NBTTagCompound getNBTData(IEnergyContainer capability, NBTTagCompound tag) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.func_74772_a("InputPerSec", capability.getInputPerSec());
        subTag.func_74772_a("OutputPerSec", capability.getOutputPerSec());
        tag.func_74782_a("gregtech.BatteryBuffer", (NBTBase)subTag);
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.battery-buffer") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.BatteryBuffer")) {
            IGregTechTileEntity iGregTechTileEntity;
            MetaTileEntity metaTileEntity;
            NBTTagCompound batteryTag = accessor.getNBTData().func_74775_l("gregtech.BatteryBuffer");
            TileEntity tileEntity = accessor.getTileEntity();
            if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = (iGregTechTileEntity = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MetaTileEntityBatteryBuffer) {
                long averageIn = batteryTag.func_74763_f("InputPerSec") / 20L;
                String averageInFormatted = I18n.func_135052_a((String)"gregtech.waila.energy_input", (Object[])new Object[]{TextFormattingUtil.formatNumbers(averageIn)});
                tooltip.add(averageInFormatted);
                long averageOut = batteryTag.func_74763_f("OutputPerSec") / 20L;
                String averageOutFormatted = I18n.func_135052_a((String)"gregtech.waila.energy_output", (Object[])new Object[]{TextFormattingUtil.formatNumbers(averageOut)});
                tooltip.add(averageOutFormatted);
            }
        }
        return tooltip;
    }
}

