/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.hwyla.provider;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityActiveTransformer;
import gregtech.integration.hwyla.provider.CapabilityDataProvider;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class ActiveTransformerDataProvider
extends CapabilityDataProvider<IMultiblockController> {
    public static final ActiveTransformerDataProvider INSTANCE = new ActiveTransformerDataProvider();

    @Override
    public void register(@NotNull IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.registerNBTProvider((IWailaDataProvider)this, TileEntity.class);
        registrar.addConfig("GregTech", "gregtech.multiblock.activetransformer");
    }

    @Override
    @NotNull
    protected Capability<IMultiblockController> getCapability() {
        return GregtechCapabilities.CAPABILITY_MULTIBLOCK_CONTROLLER;
    }

    @Override
    protected NBTTagCompound getNBTData(IMultiblockController capability, NBTTagCompound tag) {
        MetaTileEntityActiveTransformer activeTransformer;
        if (capability instanceof MetaTileEntityActiveTransformer && (activeTransformer = (MetaTileEntityActiveTransformer)capability).isStructureFormed() && activeTransformer.isActive()) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74772_a("AverageIO", activeTransformer.getAverageIOLastSec());
            tag.func_74782_a("gregtech.IMultiblockController.ActiveTransformer", (NBTBase)subTag);
        }
        return tag;
    }

    @NotNull
    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("gregtech.multiblock") || accessor.getTileEntity() == null) {
            return tooltip;
        }
        if (accessor.getNBTData().func_74764_b("gregtech.IMultiblockController.ActiveTransformer")) {
            NBTTagCompound tag = accessor.getNBTData().func_74775_l("gregtech.IMultiblockController.ActiveTransformer");
            tooltip.add(I18n.func_135052_a((String)"gregtech.waila.active_transformer.average_io", (Object[])new Object[]{TextFormattingUtil.formatNumbers(tag.func_74763_f("AverageIO"))}));
        }
        return tooltip;
    }
}

