/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.groovy;

import com.cleanroommc.groovyscript.api.GroovyLog;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.store.FluidStorageKey;
import gregtech.api.unification.Element;
import gregtech.api.unification.Elements;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialFlag;
import gregtech.api.unification.material.info.MaterialIconSet;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.ExtraToolProperty;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.GTUtility;
import gregtech.integration.groovy.GroovyScriptModule;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;

public class GroovyMaterialBuilderExpansion {
    public static Material.Builder fluid(Material.Builder builder, String raw, FluidBuilder fluidBuilder) {
        FluidStorageKey key = FluidStorageKey.getByName(new ResourceLocation(raw));
        if (key == null) {
            key = FluidStorageKey.getByName(GTUtility.gregtechId(raw));
        }
        if (GroovyScriptModule.validateNonNull(key, () -> "Can't find fluid type for " + raw + " in material builder")) {
            return builder.fluid(key, fluidBuilder);
        }
        return builder;
    }

    public static Material.Builder gas(Material.Builder builder, int temp) {
        return builder.gas(new FluidBuilder().temperature(temp));
    }

    public static Material.Builder liquid(Material.Builder builder, int temp) {
        return builder.liquid(new FluidBuilder().temperature(temp));
    }

    public static Material.Builder plasma(Material.Builder builder, int temp) {
        return builder.plasma(new FluidBuilder().temperature(temp));
    }

    public static Material.Builder element(Material.Builder builder, String raw) {
        Element element = Elements.get(raw);
        if (GroovyScriptModule.validateNonNull(element, () -> "Can't find element for " + raw + " in material builder")) {
            return builder.element(element);
        }
        return builder;
    }

    public static Material.Builder flags(Material.Builder builder, String ... rawFlags) {
        ArrayList<MaterialFlag> flags = new ArrayList<MaterialFlag>();
        for (String rawFlag : rawFlags) {
            MaterialFlag flag = MaterialFlag.getByName(rawFlag);
            if (!GroovyScriptModule.validateNonNull(flag, () -> "Can't find material flag for '" + rawFlag + "' in material builder")) continue;
            flags.add(flag);
        }
        return builder.flags(flags, new MaterialFlag[0]);
    }

    public static Material.Builder iconSet(Material.Builder builder, String raw) {
        MaterialIconSet iconSet = MaterialIconSet.getByName(raw);
        if (GroovyScriptModule.validateNonNull(iconSet, () -> "Can't find material icon set for " + raw + " in material builder")) {
            return builder.iconSet(iconSet);
        }
        return builder;
    }

    public static Material.Builder blastTemp(Material.Builder builder, int temp, String raw) {
        return GroovyMaterialBuilderExpansion.blastTemp(builder, temp, raw, -1, -1);
    }

    public static Material.Builder blastTemp(Material.Builder builder, int temp, String raw, int eutOverride) {
        return GroovyMaterialBuilderExpansion.blastTemp(builder, temp, raw, eutOverride, -1);
    }

    public static Material.Builder blastTemp(Material.Builder builder, int temp, String raw, int eutOverride, int durationOverride) {
        return GroovyMaterialBuilderExpansion.blastTemp(builder, temp, raw, eutOverride, durationOverride, -1, -1);
    }

    public static Material.Builder blastTemp(Material.Builder builder, int temp, String raw, int eutOverride, int durationOverride, int vacuumEUtOverride, int vacuumDurationOverride) {
        BlastProperty.GasTier gasTier = GroovyScriptModule.parseAndValidateEnumValue(BlastProperty.GasTier.class, raw, "gas tier");
        if (gasTier != null) {
            return builder.blast(b -> b.temp(temp, gasTier).blastStats(eutOverride, durationOverride).vacuumStats(vacuumEUtOverride, vacuumDurationOverride));
        }
        return builder;
    }

    public static Material.Builder components(Material.Builder builder, Object ... objects) {
        ObjectArrayList materialStacks = new ObjectArrayList();
        for (Object o : objects) {
            if (o instanceof MaterialStack) {
                MaterialStack materialStack = (MaterialStack)o;
                materialStacks.add((Object)materialStack);
                continue;
            }
            if (o instanceof Material) {
                Material material = (Material)o;
                materialStacks.add((Object)new MaterialStack(material, 1L));
                continue;
            }
            if (o instanceof Integer) {
                GroovyLog.msg((String)"Error creating GregTech material", (Object[])new Object[0]).add("Tried to use old method for material components in the shape of (material1, amount1, material2, amount2)", new Object[0]).add("Please change this into (material1 * amount1, material2 * amount2)", new Object[0]).error().post();
                continue;
            }
            GroovyLog.msg((String)"Error creating GregTech material", (Object[])new Object[0]).add("Material components must be of type Material or MaterialStack, but was of type {}", new Object[]{o == null ? null : o.getClass()}).error().post();
        }
        return builder.components((MaterialStack[])materialStacks.toArray((Object[])new MaterialStack[0]));
    }

    public static Material.Builder toolStats(Material.Builder builder, MaterialToolProperty.Builder toolBuilder) {
        return builder.toolStats(toolBuilder.build());
    }

    public static Material.Builder toolStats(Material.Builder builder, float harvestSpeed, float attackDamage, int durability, int harvestLevel) {
        return builder.toolStats(MaterialToolProperty.Builder.of(harvestSpeed, attackDamage, durability, harvestLevel).build());
    }

    public static Material.Builder overrideToolStats(Material.Builder builder, String toolId, ExtraToolProperty.Builder overrideBuilder) {
        return builder.overrideToolStats(toolId, overrideBuilder.build());
    }
}

