/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.forestry.mutation;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.tiles.TileUtil;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.LocalizationUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class MaterialMutationCondition
implements IMutationCondition {
    private final Set<IBlockState> acceptedBlocks = new HashSet<IBlockState>();
    private final String displayName;

    public MaterialMutationCondition(@NotNull Material material) {
        this.displayName = LocalizationUtils.format("gregtech.mutation.block_of", material.getLocalizedName());
        String oreDictName = new UnificationEntry(OrePrefix.block, material).toString();
        for (ItemStack ore : OreDictUnifier.getAllWithOreDictionaryName(oreDictName)) {
            Item oreItem;
            Block oreBlock;
            if (ore.func_190926_b() || (oreBlock = Block.func_149634_a((Item)(oreItem = ore.func_77973_b()))) == Blocks.field_150350_a) continue;
            this.acceptedBlocks.addAll((Collection<IBlockState>)oreBlock.func_176194_O().func_177619_a());
        }
    }

    public float getChance(@NotNull World world, @NotNull BlockPos pos, @NotNull IAllele allele0, @NotNull IAllele allele1, @NotNull IGenome genome0, @NotNull IGenome genome1, @NotNull IClimateProvider climate) {
        TileEntity tile;
        while ((tile = TileUtil.getTile((IBlockAccess)world, (BlockPos)(pos = pos.func_177977_b()))) instanceof IBeeHousing) {
        }
        IBlockState blockState = world.func_180495_p(pos);
        return this.acceptedBlocks.contains(blockState) ? 1.0f : 0.0f;
    }

    @NotNull
    public String getDescription() {
        return LocalizationUtils.format("for.mutation.condition.resource", this.displayName);
    }
}

