/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.crafttweaker.material;

import crafttweaker.annotations.ZenRegister;
import gregtech.api.fluids.FluidBuilder;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.FluidAttributes;
import gregtech.api.fluids.store.FluidStorageKeys;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.DustProperty;
import gregtech.api.unification.material.properties.FluidPipeProperties;
import gregtech.api.unification.material.properties.FluidProperty;
import gregtech.api.unification.material.properties.GemProperty;
import gregtech.api.unification.material.properties.IngotProperty;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.unification.material.properties.MaterialToolProperty;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.integration.crafttweaker.material.CTMaterialHelpers;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenExpansion(value="mods.gregtech.material.Material")
@ZenRegister
public class MaterialPropertyExpansion {
    @ZenMethod
    public static boolean hasBlastTemp(Material m) {
        return m.hasProperty(PropertyKey.BLAST);
    }

    @ZenMethod
    public static boolean hasDust(Material m) {
        return m.hasProperty(PropertyKey.DUST);
    }

    @ZenMethod
    public static boolean hasFluidPipes(Material m) {
        return m.hasProperty(PropertyKey.FLUID_PIPE);
    }

    @ZenMethod
    public static boolean hasFluid(Material m) {
        return m.hasProperty(PropertyKey.FLUID);
    }

    @ZenMethod
    public static boolean hasGem(Material m) {
        return m.hasProperty(PropertyKey.GEM);
    }

    @ZenMethod
    public static boolean hasIngot(Material m) {
        return m.hasProperty(PropertyKey.INGOT);
    }

    @ZenMethod
    public static boolean hasItemPipes(Material m) {
        return m.hasProperty(PropertyKey.ITEM_PIPE);
    }

    @ZenMethod
    public static boolean hasOre(Material m) {
        return m.hasProperty(PropertyKey.ORE);
    }

    @ZenMethod
    public static boolean hasTools(Material m) {
        return m.hasProperty(PropertyKey.TOOL);
    }

    @ZenMethod
    public static boolean hasWires(Material m) {
        return m.hasProperty(PropertyKey.WIRE);
    }

    @ZenMethod
    public static void addBlastTemp(Material m, int blastTemp) {
        if (CTMaterialHelpers.checkFrozen("add blast temperature")) {
            return;
        }
        if (m.hasProperty(PropertyKey.BLAST)) {
            m.getProperty(PropertyKey.BLAST).setBlastTemperature(blastTemp);
        } else {
            m.setProperty(PropertyKey.BLAST, new BlastProperty(blastTemp));
        }
    }

    @ZenMethod
    public static void addBlastProperty(Material m, int blastTemp, @Optional String gasTier, @Optional int durationOverride, @Optional int eutOverride, @Optional int vacuumDurationOverride, @Optional int vacuumEUtOverride) {
        if (CTMaterialHelpers.checkFrozen("add blast property")) {
            return;
        }
        if (m.hasProperty(PropertyKey.BLAST)) {
            BlastProperty property = m.getProperty(PropertyKey.BLAST);
            property.setBlastTemperature(blastTemp);
            if (gasTier != null) {
                property.setGasTier(BlastProperty.validateGasTier(gasTier));
            }
            if (durationOverride != 0) {
                property.setDurationOverride(durationOverride);
            }
            if (eutOverride != 0) {
                property.setEutOverride(eutOverride);
            }
            if (vacuumDurationOverride != 0) {
                property.setVacuumDurationOverride(vacuumDurationOverride);
            }
            if (vacuumEUtOverride != 0) {
                property.setVacuumEutOverride(vacuumEUtOverride);
            }
        } else {
            BlastProperty.Builder builder = new BlastProperty.Builder();
            builder.temp(blastTemp, gasTier == null ? BlastProperty.GasTier.LOW : BlastProperty.validateGasTier(gasTier));
            builder.blastStats(durationOverride == 0 ? -1 : durationOverride, eutOverride == 0 ? -1 : eutOverride);
            builder.vacuumStats(vacuumEUtOverride == 0 ? -1 : vacuumEUtOverride, vacuumDurationOverride == 0 ? -1 : vacuumDurationOverride);
            m.setProperty(PropertyKey.BLAST, builder.build());
        }
    }

    @ZenMethod
    public static void addDust(Material m, @Optional int harvestLevel, @Optional int burnTime) {
        if (CTMaterialHelpers.checkFrozen("add a dust to a material")) {
            return;
        }
        if (harvestLevel == 0) {
            harvestLevel = 2;
        }
        if (m.hasProperty(PropertyKey.DUST)) {
            m.getProperty(PropertyKey.DUST).setHarvestLevel(harvestLevel);
            m.getProperty(PropertyKey.DUST).setBurnTime(burnTime);
        } else {
            m.setProperty(PropertyKey.DUST, new DustProperty(harvestLevel, burnTime));
        }
    }

    @ZenMethod
    public static void addFluidPipes(Material m, int maxFluidTemperature, int throughput, boolean gasProof) {
        MaterialPropertyExpansion.addFluidPipes(m, maxFluidTemperature, throughput, gasProof, false, false, false);
    }

    @ZenMethod
    public static void addFluidPipes(Material m, int maxFluidTemperature, int throughput, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        if (CTMaterialHelpers.checkFrozen("add fluid pipes to a material")) {
            return;
        }
        if (m.hasProperty(PropertyKey.FLUID_PIPE)) {
            m.getProperty(PropertyKey.FLUID_PIPE).setMaxFluidTemperature(maxFluidTemperature);
            m.getProperty(PropertyKey.FLUID_PIPE).setThroughput(throughput);
            m.getProperty(PropertyKey.FLUID_PIPE).setGasProof(gasProof);
            m.getProperty(PropertyKey.FLUID_PIPE).setCanContain(FluidAttributes.ACID, acidProof);
            m.getProperty(PropertyKey.FLUID_PIPE).setCryoProof(cryoProof);
            m.getProperty(PropertyKey.FLUID_PIPE).setPlasmaProof(plasmaProof);
        } else {
            m.setProperty(PropertyKey.FLUID_PIPE, new FluidPipeProperties(maxFluidTemperature, throughput, gasProof, acidProof, cryoProof, plasmaProof));
        }
    }

    @ZenMethod
    public static void addFluid(Material m) {
        if (CTMaterialHelpers.checkFrozen("add a Fluid to a material")) {
            return;
        }
        if (!m.hasProperty(PropertyKey.FLUID)) {
            FluidProperty property = new FluidProperty();
            property.enqueueRegistration(FluidStorageKeys.LIQUID, new FluidBuilder());
            m.setProperty(PropertyKey.FLUID, property);
        }
    }

    @ZenMethod
    public static void addFluid(Material m, @Optional String fluidTypeName, @Optional boolean hasBlock) {
        FluidBuilder builder;
        if (CTMaterialHelpers.checkFrozen("add a Fluid to a material")) {
            return;
        }
        FluidState type = CTMaterialHelpers.validateFluidState(fluidTypeName);
        FluidProperty property = m.getProperty(PropertyKey.FLUID);
        if (property == null) {
            property = new FluidProperty();
            m.setProperty(PropertyKey.FLUID, property);
        }
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LIQUID: {
                FluidBuilder fluidBuilder = property.getQueuedBuilder(FluidStorageKeys.LIQUID);
                break;
            }
            case GAS: {
                FluidBuilder fluidBuilder = property.getQueuedBuilder(FluidStorageKeys.GAS);
                break;
            }
            case PLASMA: {
                FluidBuilder fluidBuilder = builder = property.getQueuedBuilder(FluidStorageKeys.PLASMA);
            }
        }
        if (builder == null) {
            builder = new FluidBuilder();
            switch (type) {
                case LIQUID: {
                    property.enqueueRegistration(FluidStorageKeys.LIQUID, builder);
                    break;
                }
                case GAS: {
                    property.enqueueRegistration(FluidStorageKeys.GAS, builder.state(FluidState.GAS));
                    break;
                }
                case PLASMA: {
                    property.enqueueRegistration(FluidStorageKeys.PLASMA, builder.state(FluidState.PLASMA));
                }
            }
        }
        if (hasBlock) {
            builder.block();
        }
    }

    @ZenMethod
    public static void addGem(Material m) {
        if (CTMaterialHelpers.checkFrozen("add a Gem to a material")) {
            return;
        }
        if (!m.hasProperty(PropertyKey.GEM)) {
            m.setProperty(PropertyKey.GEM, new GemProperty());
        }
    }

    @ZenMethod
    public static void addIngot(Material m) {
        if (CTMaterialHelpers.checkFrozen("add an Ingot to a material")) {
            return;
        }
        if (!m.hasProperty(PropertyKey.INGOT)) {
            m.setProperty(PropertyKey.INGOT, new IngotProperty());
        }
    }

    @ZenMethod
    public static void addOre(Material m, @Optional int oreMultiplier, @Optional int byproductMultiplier, @Optional boolean emissive) {
        if (CTMaterialHelpers.checkFrozen("add an Ore to a material")) {
            return;
        }
        oreMultiplier = oreMultiplier == 0 ? 1 : oreMultiplier;
        int n = byproductMultiplier = byproductMultiplier == 0 ? 1 : byproductMultiplier;
        if (m.hasProperty(PropertyKey.ORE)) {
            m.getProperty(PropertyKey.ORE).setOreMultiplier(oreMultiplier);
            m.getProperty(PropertyKey.ORE).setByProductMultiplier(byproductMultiplier);
            m.getProperty(PropertyKey.ORE).setEmissive(emissive);
        } else {
            m.setProperty(PropertyKey.ORE, new OreProperty(oreMultiplier, byproductMultiplier, emissive));
        }
    }

    @ZenMethod
    public static void addItemPipes(Material m, int priority, float transferRate) {
        if (CTMaterialHelpers.checkFrozen("add Item Pipes to a material")) {
            return;
        }
        if (m.hasProperty(PropertyKey.ITEM_PIPE)) {
            m.getProperty(PropertyKey.ITEM_PIPE).setPriority(priority);
            m.getProperty(PropertyKey.ITEM_PIPE).setTransferRate(transferRate);
        } else {
            m.setProperty(PropertyKey.ITEM_PIPE, new ItemPipeProperties(priority, transferRate));
        }
    }

    @ZenMethod
    public static void addPlasma(Material m) {
        if (CTMaterialHelpers.checkFrozen("add a Plasma to a material")) {
            return;
        }
        if (!m.hasProperty(PropertyKey.FLUID)) {
            FluidProperty property = new FluidProperty();
            property.enqueueRegistration(FluidStorageKeys.PLASMA, new FluidBuilder().state(FluidState.PLASMA));
            m.setProperty(PropertyKey.FLUID, property);
        }
    }

    @ZenMethod
    public static void addTools(Material m, float toolSpeed, float toolAttackDamage, float toolAttackSpeed, int toolDurability, @Optional int toolHarvestLevel, @Optional int toolEnchantability, @Optional int durabilityMultiplier) {
        if (CTMaterialHelpers.checkFrozen("add Tools to a material")) {
            return;
        }
        if (toolEnchantability == 0) {
            toolEnchantability = 10;
        }
        if (durabilityMultiplier <= 0) {
            durabilityMultiplier = 1;
        }
        if (m.hasProperty(PropertyKey.TOOL)) {
            m.getProperty(PropertyKey.TOOL).setToolSpeed(toolSpeed);
            m.getProperty(PropertyKey.TOOL).setToolAttackDamage(toolAttackDamage);
            m.getProperty(PropertyKey.TOOL).setToolAttackSpeed(toolAttackSpeed);
            m.getProperty(PropertyKey.TOOL).setToolDurability(toolDurability);
            m.getProperty(PropertyKey.TOOL).setToolHarvestLevel(toolHarvestLevel);
            m.getProperty(PropertyKey.TOOL).setToolEnchantability(toolEnchantability);
            m.getProperty(PropertyKey.TOOL).setDurabilityMultiplier(durabilityMultiplier);
        } else {
            m.setProperty(PropertyKey.TOOL, MaterialToolProperty.Builder.of(toolSpeed, toolAttackDamage, toolDurability, toolHarvestLevel).attackSpeed(toolAttackSpeed).enchantability(toolEnchantability).durabilityMultiplier(durabilityMultiplier).build());
        }
    }

    @ZenMethod
    public static void addWires(Material m, int voltage, int baseAmperage, int lossPerBlock, @Optional boolean isSuperCon, @Optional int criticalTemp) {
        if (CTMaterialHelpers.checkFrozen("add Wires to a material")) {
            return;
        }
        if (m.hasProperty(PropertyKey.WIRE)) {
            m.getProperty(PropertyKey.WIRE).setVoltage(voltage);
            m.getProperty(PropertyKey.WIRE).setAmperage(baseAmperage);
            m.getProperty(PropertyKey.WIRE).setLossPerBlock(lossPerBlock);
            m.getProperty(PropertyKey.WIRE).setSuperconductor(isSuperCon);
            m.getProperty(PropertyKey.WIRE).setSuperconductorCriticalTemperature(criticalTemp);
        } else {
            m.setProperty(PropertyKey.WIRE, new WireProperties(voltage, baseAmperage, lossPerBlock, isSuperCon, criticalTemp));
        }
    }
}

