/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.chisel;

import gregtech.api.block.VariantBlock;
import gregtech.api.modules.GregTechModule;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.common.blocks.BlockColored;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockWarningSign;
import gregtech.common.blocks.BlockWarningSign1;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.StoneVariantBlock;
import gregtech.common.blocks.wood.BlockGregPlanks;
import gregtech.integration.IntegrationSubmodule;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import team.chisel.common.carving.Carving;

@GregTechModule(moduleID="chisel_integration", containerID="gregtech", modDependencies={"chisel"}, name="GregTech Chisel Integration", description="Chisel Integration Module")
public class ChiselModule
extends IntegrationSubmodule {
    @Override
    public void init(FMLInitializationEvent event) {
        this.addVariations("gt_warning_sign", MetaBlocks.WARNING_SIGN, BlockWarningSign.SignType.values());
        this.addVariations("gt_warning_sign", MetaBlocks.WARNING_SIGN_1, BlockWarningSign1.SignType.values());
        this.addVariations("gt_studs", MetaBlocks.STUDS);
        this.addVariations("gt_metal_sheet", MetaBlocks.METAL_SHEET);
        this.addVariations("gt_large_metal_sheet", MetaBlocks.LARGE_METAL_SHEET);
        for (EnumDyeColor color : EnumDyeColor.values()) {
            Block lamp = MetaBlocks.LAMPS.get(color);
            Block lampBorderless = MetaBlocks.BORDERLESS_LAMPS.get(color);
            String group = "gt_lamp_" + color.func_176610_l().toLowerCase();
            for (int i = 0; i < 8; ++i) {
                this.addVariation(group, lamp, i);
                this.addVariation(group, lampBorderless, i);
            }
        }
        this.addVariations("marble", StoneVariantBlock.StoneType.MARBLE, false);
        this.addVariations("basalt", StoneVariantBlock.StoneType.BASALT, false);
        this.addVariations("black_granite", StoneVariantBlock.StoneType.BLACK_GRANITE, false);
        this.addVariations("red_granite", StoneVariantBlock.StoneType.RED_GRANITE, false);
        this.addVariations("light_concrete", StoneVariantBlock.StoneType.CONCRETE_LIGHT, true);
        this.addVariations("dark_concrete", StoneVariantBlock.StoneType.CONCRETE_DARK, true);
        if (this.doesGroupExist("treated_wood")) {
            this.addVariations("treated_wood", MetaBlocks.PLANKS, new BlockGregPlanks.BlockType[]{BlockGregPlanks.BlockType.TREATED_PLANK});
        }
        if (this.doesGroupExist("certus")) {
            this.addVariation("certus", Materials.CertusQuartz);
        }
    }

    @SafeVarargs
    private <U extends Enum<U>, T extends VariantBlock<U>> void addVariations(String group, T block, U ... variants) {
        if (variants != null) {
            for (U variant : variants) {
                this.addVariation(group, (Block)block, ((VariantBlock)((Object)block)).func_176201_c(((VariantBlock)((Object)block)).getState(variant)));
            }
        }
    }

    private void addVariations(String group, BlockColored block) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.addVariation(group, block, color.func_176765_a());
        }
    }

    private void addVariations(String group, StoneVariantBlock.StoneType type, boolean enableCobbles) {
        for (StoneVariantBlock.StoneVariant variant : StoneVariantBlock.StoneVariant.values()) {
            if (!enableCobbles && (variant == StoneVariantBlock.StoneVariant.COBBLE || variant == StoneVariantBlock.StoneVariant.COBBLE_MOSSY)) continue;
            StoneVariantBlock block = MetaBlocks.STONE_BLOCKS.get((Object)variant);
            int meta = block.func_176201_c(block.getState(type));
            this.addVariation(group, block, meta);
        }
    }

    private void addVariation(String group, Material material) {
        BlockCompressed block = MetaBlocks.COMPRESSED.get(material);
        int meta = block.func_176201_c(block.getBlock(material));
        this.addVariation(group, block, meta);
    }

    private void addVariation(String group, Block block, int meta) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("group", group);
        tag.func_74778_a("block", Objects.requireNonNull(block.getRegistryName()).toString());
        tag.func_74768_a("meta", meta);
        FMLInterModComms.sendMessage((String)"chisel", (String)"add_variation", (NBTTagCompound)tag);
    }

    private boolean doesGroupExist(String group) {
        return Carving.chisel.getGroup(group) != null;
    }
}

