/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.bq;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import gregtech.api.GregTechAPI;
import gregtech.datafix.migration.lib.MTERegistriesMigrator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class BQuDataFixer {
    private static final Logger LOG = LogManager.getLogger(BQuDataFixer.class);
    private static final String QUEST_DB_JSON_FILE = "QuestDatabase.json";
    private static final String BQ_RESOURCES_DIR = "resources";
    private static final String MC_CONFIG_DIR = "config";
    private static final String ID_8 = "id:8";
    private static final String DAMAGE_2 = "Damage:2";
    private static final String TAG_10 = "tag:10";
    private static final String ORIG_ID_8 = "orig_id:8";
    private static final String ORIG_META_3 = "orig_meta:3";
    private static final String PLACEHOLDER = "betterquesting:placeholder";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private BQuDataFixer() {
    }

    public static void onServerStarting(@NotNull ICommandSender server) {
        LOG.info("Attempting to apply BQu DataFixers");
        Path worldDir = server.func_130014_f_().func_72860_G().func_75765_b().toPath();
        if (BQuDataFixer.processWorldDir(worldDir)) {
            LOG.info("Successfully applied BQu data fixers");
        } else {
            LOG.error("Failed to apply BQu data fixers");
        }
    }

    public static boolean processWorldDir(@NotNull Path worldDir) {
        JsonObject json;
        LOG.info("Processing world directory");
        Path bqDir = worldDir.resolve("betterquesting");
        Path questDbPath = bqDir.resolve(QUEST_DB_JSON_FILE);
        if (!Files.isRegularFile(questDbPath, new LinkOption[0])) {
            LOG.info("Unable to find BQ Quest Database, assuming this is a new world");
            return true;
        }
        try {
            json = BQuDataFixer.readJson(questDbPath);
        }
        catch (FileNotFoundException e) {
            LOG.info("Unable to find BQ Quest Database, assuming this is a new world");
            return true;
        }
        catch (IOException e) {
            LOG.error("Failed to read BQ Quest Database in World Folder", (Throwable)e);
            return false;
        }
        for (Map.Entry entry : json.entrySet()) {
            BQuDataFixer.recurseJsonApplyFix((JsonElement)entry.getValue());
        }
        try {
            BQuDataFixer.writeJson(questDbPath, json);
        }
        catch (IOException e) {
            LOG.error("Failed to write BQ Quest DataBase in World Folder", (Throwable)e);
        }
        return true;
    }

    public static boolean processConfigDir(@NotNull Path worldDir) {
        List paths;
        LOG.info("Processing config directory");
        Path mcDir = worldDir.getParent().getParent();
        Path configDir = mcDir.resolve(MC_CONFIG_DIR);
        Path bqConfigDir = configDir.resolve("betterquesting");
        try (Stream<Path> stream = Files.walk(bqConfigDir, 4, new FileVisitOption[0]);){
            paths = stream.filter(p -> !p.endsWith(BQ_RESOURCES_DIR)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toFile().getName().endsWith(".json")).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOG.error("Failed to read BQ Quest Database in Config Folder", (Throwable)e);
            return false;
        }
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(paths.size());
        for (Path path2 : paths) {
            try {
                map.put(path2, BQuDataFixer.readJson(path2));
            }
            catch (IOException e) {
                LOG.error("Failed to read BQ Quest File from Config Folder", (Throwable)e);
            }
        }
        map.values().stream().flatMap(jsonObject -> jsonObject.entrySet().stream()).map(Map.Entry::getValue).forEach(BQuDataFixer::recurseJsonApplyFix);
        for (Map.Entry entry : map.entrySet()) {
            try {
                BQuDataFixer.writeJson((Path)entry.getKey(), (JsonObject)entry.getValue());
            }
            catch (IOException e) {
                LOG.error("Failed to write BQ Quest File in Config Folder", (Throwable)e);
            }
        }
        return true;
    }

    @NotNull
    private static JsonObject readJson(@NotNull Path path) throws IOException {
        LOG.info("Reading file at path {}", (Object)path);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
    }

    private static void recurseJsonApplyFix(@NotNull JsonElement element) {
        block5: {
            block4: {
                if (!element.isJsonObject()) break block4;
                JsonObject object = element.getAsJsonObject();
                if (object.has(ID_8)) {
                    BQuDataFixer.applyDataFix(object);
                } else {
                    for (Map.Entry entry : object.entrySet()) {
                        BQuDataFixer.recurseJsonApplyFix((JsonElement)entry.getValue());
                    }
                }
                break block5;
            }
            if (!element.isJsonArray()) break block5;
            for (JsonElement value : element.getAsJsonArray()) {
                BQuDataFixer.recurseJsonApplyFix(value);
            }
        }
    }

    private static void writeJson(@NotNull Path path, @NotNull JsonObject jsonObject) throws IOException {
        LOG.info("Writing file to path {}", (Object)path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
    }

    private static void applyDataFix(@NotNull JsonObject jsonObject) {
        short fixedMeta;
        short meta;
        ResourceLocation itemBlockId;
        MTERegistriesMigrator migrator = GregTechAPI.MIGRATIONS.registriesMigrator();
        String id = jsonObject.get(ID_8).getAsString();
        boolean isPlaceHolder = PLACEHOLDER.equals(id);
        if (isPlaceHolder) {
            JsonObject orig = jsonObject.getAsJsonObject(TAG_10);
            if (orig == null) {
                return;
            }
            if (!orig.has(ORIG_ID_8) || !orig.has(ORIG_META_3)) {
                return;
            }
            itemBlockId = new ResourceLocation(orig.get(ORIG_ID_8).getAsString());
            meta = orig.get(ORIG_META_3).getAsShort();
        } else {
            itemBlockId = new ResourceLocation(id);
            meta = jsonObject.get(DAMAGE_2).getAsShort();
        }
        ResourceLocation fixedName = migrator.fixItemName(itemBlockId, meta);
        if (fixedName != null) {
            jsonObject.add(ID_8, (JsonElement)new JsonPrimitive(fixedName.toString()));
        }
        if ((fixedMeta = migrator.fixItemMeta(itemBlockId, meta)) != meta) {
            jsonObject.add(DAMAGE_2, (JsonElement)new JsonPrimitive((Number)fixedMeta));
        }
        if (isPlaceHolder) {
            jsonObject.remove(TAG_10);
        }
    }
}

