/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration;

import gregtech.api.GregTechAPI;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.integration.crafttweaker.CTRecipeHelper;
import gregtech.integration.groovy.GrSRecipeHelper;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecipeCompatUtil {
    private RecipeCompatUtil() {
    }

    @NotNull
    public static String getFirstOutputString(@NotNull Recipe recipe) {
        String output = "";
        if (!recipe.getOutputs().isEmpty()) {
            ItemStack item = recipe.getOutputs().get(0);
            output = item.func_82833_r() + " * " + item.func_190916_E();
        } else if (!recipe.getFluidOutputs().isEmpty()) {
            FluidStack fluid = recipe.getFluidOutputs().get(0);
            output = fluid.getLocalizedName() + " * " + fluid.amount;
        }
        return output;
    }

    @Nullable
    public static String getMetaItemId(ItemStack item) {
        Object metaValueItem;
        if (item.func_77973_b() instanceof MetaItem && (metaValueItem = ((MetaItem)item.func_77973_b()).getItem(item)) != null) {
            String nameSpace = Objects.requireNonNull(((MetaItem.MetaValueItem)metaValueItem).getMetaItem().getRegistryName()).func_110624_b();
            String name = ((MetaItem.MetaValueItem)metaValueItem).unlocalizedName;
            return nameSpace.equals("gregtech") ? name : nameSpace + ":" + name;
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            MetaTileEntity mte;
            Block block = ((ItemBlock)item.func_77973_b()).func_179223_d();
            if (item.func_77973_b() instanceof MachineItemBlock && (mte = GTUtility.getMetaTileEntity(item)) != null) {
                return mte.metaTileEntityId.func_110624_b().equals("gregtech") ? mte.metaTileEntityId.func_110623_a() : mte.metaTileEntityId.toString();
            }
            if (block instanceof BlockCompressed) {
                BlockCompressed blockCompressed = (BlockCompressed)block;
                Material material = blockCompressed.getGtMaterial(item);
                return RecipeCompatUtil.getRLPrefix(material) + "block" + material.toCamelCaseString();
            }
            if (block instanceof BlockFrame) {
                BlockFrame blockFrame = (BlockFrame)block;
                Material material = blockFrame.getGtMaterial(item);
                return RecipeCompatUtil.getRLPrefix(material) + "frame" + material.toCamelCaseString();
            }
            if (block instanceof BlockMaterialPipe) {
                BlockMaterialPipe blockMaterialPipe = (BlockMaterialPipe)block;
                Material material = blockMaterialPipe.getItemMaterial(item);
                return RecipeCompatUtil.getRLPrefix(material) + blockMaterialPipe.getPrefix().name + material.toCamelCaseString();
            }
        }
        return null;
    }

    public static String getRecipeRemoveLine(RecipeMap<?> recipeMap, Recipe recipe) {
        TweakerType type = RecipeCompatUtil.getPriorityTweaker();
        if (type == TweakerType.GROOVYSCRIPT) {
            return GrSRecipeHelper.getRecipeRemoveLine(recipeMap, recipe);
        }
        if (type == TweakerType.CRAFTTWEAKER) {
            return CTRecipeHelper.getRecipeRemoveLine(recipeMap, recipe);
        }
        return null;
    }

    @NotNull
    public static TweakerType getPriorityTweaker() {
        if (GregTechAPI.moduleManager.isModuleEnabled("grs_integration")) {
            return TweakerType.GROOVYSCRIPT;
        }
        if (GregTechAPI.moduleManager.isModuleEnabled("ct_integration")) {
            return TweakerType.CRAFTTWEAKER;
        }
        return TweakerType.NONE;
    }

    public static String getRLPrefix(Material material) {
        return material.getModid().equals("gregtech") ? "" : material.getModid() + ":";
    }

    public static boolean isTweakerLoaded() {
        return RecipeCompatUtil.getPriorityTweaker() != TweakerType.NONE;
    }

    public static String getTweakerName() {
        return RecipeCompatUtil.getPriorityTweaker().toString();
    }

    public static enum TweakerType {
        CRAFTTWEAKER("CraftTweaker"),
        GROOVYSCRIPT("GroovyScript"),
        NONE("");

        final String name;

        private TweakerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

