/*
 * Decompiled with CFR 0.152.
 */
package gregtech.datafix.migration.lib;

import gregtech.api.util.GTUtility;
import gregtech.datafix.GTDataVersion;
import gregtech.datafix.migration.api.AbstractMTEMigrator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.util.stream.IntStream;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTERegistriesMigrator
extends AbstractMTEMigrator {
    private static final ResourceLocation OLD_BLOCK_ID = GTUtility.gregtechId("machine");
    private static final String NEW_BLOCK_NAME = "mte";
    private final Short2ObjectMap<String> metaModidMap = new Short2ObjectOpenHashMap();
    private final Short2ShortMap metaMetaMap = new Short2ShortOpenHashMap();

    @ApiStatus.Internal
    public MTERegistriesMigrator() {
        super(GTDataVersion.V1_POST_MTE.ordinal());
        this.metaMetaMap.defaultReturnValue((short)-1);
    }

    public void migrate(int preMeta, int postMeta) {
        this.metaMetaMap.put((short)preMeta, (short)postMeta);
    }

    public void migrate(@NotNull String modid, short meta) {
        this.metaModidMap.put(meta, (Object)modid);
    }

    public void migrate(@NotNull String modid, @NotNull IntStream metaValues) {
        metaValues.forEach(i -> this.metaModidMap.put((short)i, (Object)modid));
    }

    @Override
    @Nullable
    public ResourceLocation fixMTEid(@NotNull ResourceLocation original) {
        return null;
    }

    @Override
    public void fixMTEData(@NotNull ResourceLocation original, @NotNull NBTTagCompound tag) {
    }

    @Override
    @Nullable
    public ResourceLocation fixItemName(@NotNull ResourceLocation original, short originalMeta) {
        if (OLD_BLOCK_ID.equals((Object)original)) {
            String modid = (String)this.metaModidMap.get(originalMeta);
            if (modid == null) {
                return null;
            }
            return new ResourceLocation(modid, NEW_BLOCK_NAME);
        }
        return null;
    }

    @Override
    public short fixItemMeta(@NotNull ResourceLocation itemName, short meta) {
        short fixed = this.metaMetaMap.get(meta);
        return fixed < 0 ? meta : fixed;
    }
}

