/*
 * Decompiled with CFR 0.152.
 */
package gregtech.datafix.migration.lib;

import gregtech.api.GregTechAPI;
import gregtech.datafix.GTFixType;
import gregtech.datafix.migration.api.AbstractMTEMigrator;
import gregtech.datafix.migration.impl.MigrateMTEBlockTE;
import gregtech.datafix.migration.impl.MigrateMTEItems;
import gregtech.datafix.migration.lib.MTERegistriesMigrator;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTEDataMigrator
extends AbstractMTEMigrator {
    private final Object2ObjectMap<ResourceLocation, ResourceLocation> nameMap = new Object2ObjectOpenHashMap();
    private final Map<String, Short2ShortMap> itemBlockMeta = new Object2ObjectOpenHashMap();
    private final Map<ResourceLocation, Consumer<NBTTagCompound>> mteMigrators = new Object2ObjectOpenHashMap();
    private final MTERegistriesMigrator registriesMigrator = GregTechAPI.MIGRATIONS.registriesMigrator();

    public MTEDataMigrator(@NotNull ModFixs fixer, int fixVersion) {
        super(fixVersion);
        fixer.registerFix((IFixType)GTFixType.ITEM_STACK_LIKE, (IFixableData)new MigrateMTEItems(this));
        fixer.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new MigrateMTEBlockTE(this));
    }

    public void migrateMTEName(@NotNull ResourceLocation preRegistryName, @NotNull ResourceLocation postRegistryName) {
        this.nameMap.put((Object)preRegistryName, (Object)postRegistryName);
    }

    public void migrateMTEData(@NotNull ResourceLocation preRegistryName, @NotNull @NotNull Consumer<@NotNull NBTTagCompound> migrator) {
        this.mteMigrators.put(preRegistryName, migrator);
    }

    public void migrateMTEMeta(@NotNull String modid, int preMeta, int postMeta) {
        Short2ShortMap mappings = this.itemBlockMeta.computeIfAbsent(modid, k -> {
            Short2ShortOpenHashMap map = new Short2ShortOpenHashMap();
            map.defaultReturnValue((short)-1);
            return map;
        });
        mappings.put((short)preMeta, (short)postMeta);
    }

    @Override
    @Nullable
    public ResourceLocation fixMTEid(@NotNull ResourceLocation original) {
        return (ResourceLocation)this.nameMap.get((Object)original);
    }

    @Override
    public void fixMTEData(@NotNull ResourceLocation original, @NotNull NBTTagCompound tag) {
        Consumer<NBTTagCompound> migrator = this.mteMigrators.get(original);
        if (migrator != null) {
            migrator.accept(tag);
        }
    }

    @Override
    public short fixItemMeta(@NotNull ResourceLocation itemName, short meta) {
        short newMeta;
        meta = this.registriesMigrator.fixItemMeta(itemName, meta);
        Short2ShortMap map = this.itemBlockMeta.get(itemName.func_110624_b());
        if (map != null && (newMeta = map.get(meta)) > 0) {
            return newMeta;
        }
        return meta;
    }

    @Override
    @Nullable
    public ResourceLocation fixItemName(@NotNull ResourceLocation original, short originalMeta) {
        return this.registriesMigrator.fixItemName(original, originalMeta);
    }
}

