/*
 * Decompiled with CFR 0.152.
 */
package gregtech.datafix.migration.impl;

import gregtech.api.GregTechAPI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.registry.MTERegistry;
import gregtech.datafix.migration.api.MTEMigrator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraftforge.registries.GameData;
import org.jetbrains.annotations.NotNull;

public class MigrateMTEBlockTE
implements IFixableData {
    private static final String META_ID = "MetaId";
    private static final String META_TILE_ENTITY = "MetaTileEntity";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String X_POS = "xPos";
    private static final String Z_POS = "zPos";
    private static final String CHUNK_SECTION_Y = "Y";
    private static final String CHUNK_SECTION_BLOCKS = "Blocks";
    private static final String CHUNK_SECTION_DATA = "Data";
    private static final String CHUNK_SECTION_ADD = "Add";
    private static final int BLOCKS_PER_SECTION = 4096;
    private final MTEMigrator migrator;

    public MigrateMTEBlockTE(@NotNull MTEMigrator migrator) {
        this.migrator = migrator;
    }

    public int func_188216_a() {
        return this.migrator.fixVersion();
    }

    @NotNull
    public NBTTagCompound func_188217_a(@NotNull NBTTagCompound compound) {
        if (!compound.func_150297_b("Level", 10)) {
            return compound;
        }
        NBTTagCompound level = compound.func_74775_l("Level");
        MigrateMTEBlockTE.processChunkSections(level, this.gatherMTEs(level));
        return compound;
    }

    @NotNull
    private Map<BlockPos, ResourceLocation> gatherMTEs(@NotNull NBTTagCompound level) {
        Object2ObjectOpenHashMap mteIds = new Object2ObjectOpenHashMap();
        NBTTagList tileEntityTagList = level.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntityTagList.func_74745_c(); ++i) {
            NBTTagCompound tileEntityTag = tileEntityTagList.func_150305_b(i);
            if (!tileEntityTag.func_150297_b(META_ID, 8) || !tileEntityTag.func_150297_b(META_TILE_ENTITY, 10)) continue;
            BlockPos pos = new BlockPos(tileEntityTag.func_74762_e(X), tileEntityTag.func_74762_e(Y), tileEntityTag.func_74762_e(Z));
            ResourceLocation mteId = new ResourceLocation(tileEntityTag.func_74779_i(META_ID));
            this.migrator.fixMTEData(mteId, tileEntityTag.func_74775_l(META_TILE_ENTITY));
            ResourceLocation fixedId = this.migrator.fixMTEid(mteId);
            if (fixedId != null) {
                tileEntityTag.func_74778_a(META_ID, fixedId.toString());
                mteId = fixedId;
            }
            mteIds.put(pos, mteId);
        }
        return mteIds;
    }

    private static void processChunkSections(@NotNull NBTTagCompound level, @NotNull Map<BlockPos, ResourceLocation> mteIds) {
        if (mteIds.isEmpty()) {
            return;
        }
        ObjectIntIdentityMap blockStateIDMap = GameData.getBlockStateIDMap();
        ChunkPos chunkPos = new ChunkPos(level.func_74762_e(X_POS), level.func_74762_e(Z_POS));
        NBTTagList sectionTagList = level.func_150295_c("Sections", 10);
        for (int i = 0; i < sectionTagList.func_74745_c(); ++i) {
            NBTTagCompound chunkSectionTag = sectionTagList.func_150305_b(i);
            byte sectionY = chunkSectionTag.func_74771_c(CHUNK_SECTION_Y);
            byte[] blockIDs = chunkSectionTag.func_74770_j(CHUNK_SECTION_BLOCKS);
            NibbleArray blockData = new NibbleArray(chunkSectionTag.func_74770_j(CHUNK_SECTION_DATA));
            NibbleArray extendedIDs = chunkSectionTag.func_150297_b(CHUNK_SECTION_ADD, 7) ? new NibbleArray(chunkSectionTag.func_74770_j(CHUNK_SECTION_ADD)) : null;
            for (int j = 0; j < 4096; ++j) {
                MTERegistry registry;
                MetaTileEntity mte;
                int x = j & 0xF;
                int y = j >> 8 & 0xF;
                int z = j >> 4 & 0xF;
                BlockPos pos = chunkPos.func_180331_a(x, sectionY << 4 | y, z);
                ResourceLocation mteID = mteIds.get(pos);
                if (mteID == null || (mte = (MetaTileEntity)(registry = GregTechAPI.mteManager.getRegistry(mteID.func_110624_b())).func_82594_a(mteID)) == null) continue;
                int newStateID = blockStateIDMap.func_148747_b((Object)mte.getBlock().func_176223_P());
                byte newBlockID = (byte)(newStateID >> 4 & 0xFF);
                byte newBlockIDExt = (byte)(newStateID >> 12 & 0xF);
                byte newBlockData = (byte)(newStateID & 0xF);
                blockIDs[j] = newBlockID;
                if (newBlockIDExt != 0) {
                    if (extendedIDs == null) {
                        extendedIDs = new NibbleArray();
                    }
                    extendedIDs.func_76581_a(x, y, z, (int)newBlockIDExt);
                }
                blockData.func_76581_a(x, y, z, (int)newBlockData);
            }
            chunkSectionTag.func_74773_a(CHUNK_SECTION_BLOCKS, blockIDs);
            chunkSectionTag.func_74773_a(CHUNK_SECTION_DATA, blockData.func_177481_a());
            if (extendedIDs == null) continue;
            chunkSectionTag.func_74773_a(CHUNK_SECTION_ADD, extendedIDs.func_177481_a());
        }
    }
}

