/*
 * Decompiled with CFR 0.152.
 */
package gregtech.datafix;

import gregtech.api.GregTechAPI;
import gregtech.datafix.GTDataVersion;
import gregtech.datafix.GTFixType;
import gregtech.datafix.impl.V2PostMTEReallocFixer;
import gregtech.datafix.migration.impl.MigrateMTEBlockTE;
import gregtech.datafix.migration.impl.MigrateMTEItems;
import gregtech.datafix.migration.lib.MTEDataMigrator;
import gregtech.datafix.migration.lib.MTERegistriesMigrator;
import gregtech.datafix.walker.WalkItemStackLike;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class GTDataFixers {
    public static final Logger LOGGER = LogManager.getLogger((String)"GregTech DataFixers");
    private static final IDataWalker ITEM_STACK_WALKER = new WalkItemStackLike();

    private GTDataFixers() {
    }

    public static void init() {
        CompoundDataFixer forgeFixer = FMLCommonHandler.instance().getDataFixer();
        GTDataFixers.registerWalkers(forgeFixer);
        GTDataFixers.registerFixes(forgeFixer);
        GTDataFixers.migrateMTERegistries();
    }

    private static void registerWalkers(@NotNull CompoundDataFixer fixer) {
        fixer.func_188255_a((IFixType)FixTypes.BLOCK_ENTITY, ITEM_STACK_WALKER);
        fixer.func_188255_a((IFixType)FixTypes.ENTITY, ITEM_STACK_WALKER);
        fixer.func_188255_a((IFixType)FixTypes.PLAYER, ITEM_STACK_WALKER);
    }

    private static void registerFixes(@NotNull CompoundDataFixer forgeFixer) {
        LOGGER.info("GT data version is: {}", (Object)GTDataVersion.currentVersion());
        ModFixs fixer = forgeFixer.init("gregtech", GTDataVersion.currentVersion().ordinal());
        for (GTDataVersion version : GTDataVersion.VALUES) {
            GTDataFixers.registerFixes(version, fixer);
        }
    }

    private static void registerFixes(@NotNull GTDataVersion version, @NotNull ModFixs fixer) {
        if (version != GTDataVersion.V0_PRE_MTE) {
            LOGGER.info("Registering fixer for data version {}", (Object)version);
        }
        switch (version) {
            case V1_POST_MTE: {
                MTERegistriesMigrator migrator = GregTechAPI.MIGRATIONS.registriesMigrator();
                fixer.registerFix((IFixType)GTFixType.ITEM_STACK_LIKE, (IFixableData)new MigrateMTEItems(migrator));
                fixer.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new MigrateMTEBlockTE(migrator));
                break;
            }
            case V2_POST_ID_REALLOC: {
                MTEDataMigrator dataMigrator = new MTEDataMigrator(fixer, version.ordinal());
                V2PostMTEReallocFixer.apply(dataMigrator);
                break;
            }
        }
    }

    private static void migrateMTERegistries() {
        MTERegistriesMigrator migrator = GregTechAPI.MIGRATIONS.registriesMigrator();
        migrator.migrate("gregtech", IntStream.range(0, 2000));
    }
}

