/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.network.packets;

import gregtech.api.GregTechAPI;
import gregtech.api.items.toolitem.ItemGTToolbelt;
import gregtech.api.network.IClientExecutor;
import gregtech.api.network.IPacket;
import gregtech.api.network.IServerExecutor;
import gregtech.core.sound.GTSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PacketToolbeltSelectionChange
implements IPacket {
    protected int slot;

    public PacketToolbeltSelectionChange() {
    }

    public PacketToolbeltSelectionChange(int slot) {
        this.slot = slot;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeByte(this.slot);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.slot = buf.readByte();
    }

    public static void toClient(int slot, int matrixSlot, EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        GregTechAPI.networkHandler.sendTo(new Client(slot, matrixSlot), player);
    }

    public static void toServer(int slot) {
        GregTechAPI.networkHandler.sendToServer(new Server(slot));
    }

    public static class Client
    extends PacketToolbeltSelectionChange
    implements IClientExecutor {
        int index;

        public Client() {
        }

        public Client(int slot, int index) {
            super(slot);
            this.index = index;
        }

        @Override
        public void encode(PacketBuffer buf) {
            super.encode(buf);
            buf.func_150787_b(this.index);
        }

        @Override
        public void decode(PacketBuffer buf) {
            super.decode(buf);
            this.index = buf.func_150792_a();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void executeClient(NetHandlerPlayClient handler) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack stack = player.field_71070_bA.func_75139_a(this.index).func_75211_c();
            Item item = stack.func_77973_b();
            if (item instanceof ItemGTToolbelt) {
                ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
                toolbelt.setSelectedTool(this.slot, stack);
            }
        }
    }

    public static class Server
    extends PacketToolbeltSelectionChange
    implements IServerExecutor {
        public Server() {
        }

        public Server(int slot) {
            super(slot);
        }

        @Override
        public void executeServer(NetHandlerPlayServer handler) {
            EntityPlayerMP player = handler.field_147369_b;
            ItemStack stack = player.func_184614_ca();
            Item item = stack.func_77973_b();
            if (item instanceof ItemGTToolbelt) {
                ItemGTToolbelt toolbelt = (ItemGTToolbelt)item;
                player.func_71121_q().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, GTSoundEvents.CLICK, SoundCategory.PLAYERS, 2.0f, 1.0f);
                toolbelt.setSelectedTool(this.slot, stack);
            }
        }
    }
}

